/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.cn.local;

import java.util.Map;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.client.cn.ProviderNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.local.AbstractLocalNegotiationClient;

public class LocalProviderNegotiationClientImpl
extends AbstractLocalNegotiationClient
implements ProviderNegotiationClient {
    private final Connector systemConnector;

    public LocalProviderNegotiationClientImpl(Connector systemConnector) {
        this.systemConnector = systemConnector;
    }

    @Override
    public Map<String, Object> contractRequest(Map<String, Object> contractRequest, String counterPartyId, boolean expectError) {
        return this.execute("contractRequest", contractRequest, expectError, compacted -> {
            Map negotiation = this.systemConnector.getProviderNegotiationManager().handleContractRequest(compacted, counterPartyId);
            return MessageSerializer.processJsonLd((Map)negotiation);
        });
    }

    @Override
    public void contractOfferRequest(Map<String, Object> message, String counterPartyId, boolean expectError) {
        this.contractRequest(message, counterPartyId, expectError);
    }

    @Override
    public void accept(Map<String, Object> event) {
        Map compacted = MessageSerializer.processJsonLd(event);
        this.systemConnector.getProviderNegotiationManager().handleAccepted(compacted);
    }

    @Override
    public void verify(Map<String, Object> event, boolean expectError) {
        this.execute("verify", event, expectError, compacted -> {
            this.systemConnector.getProviderNegotiationManager().handleVerified(compacted);
            return null;
        });
    }

    @Override
    public void terminate(String counterPartyId, Map<String, Object> termination, String callbackAddress, boolean expectError) {
        this.execute("termination", termination, expectError, compacted -> {
            this.systemConnector.getProviderNegotiationManager().terminated(compacted);
            return null;
        });
    }

    @Override
    public Map<String, Object> getNegotiation(String providerPid) {
        ContractNegotiation negotiation = this.systemConnector.getProviderNegotiationManager().findById(providerPid);
        String consumerPid = negotiation.getCorrelationId();
        return MessageSerializer.processJsonLd((Map)NegotiationFunctions.createNegotiationResponse((String)providerPid, (String)consumerPid, (String)negotiation.getState().toString()));
    }
}

