/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.cn.local;

import java.util.Map;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.dsp.system.api.connector.Connector;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.system.client.cn.ConsumerNegotiationClient;
import org.eclipse.dataspacetck.dsp.system.client.cn.local.AbstractLocalNegotiationClient;

public class LocalConsumerNegotiationClientImpl
extends AbstractLocalNegotiationClient
implements ConsumerNegotiationClient {
    private final Connector systemConsumerConnector;

    public LocalConsumerNegotiationClientImpl(Connector consumerConnector) {
        this.systemConsumerConnector = consumerConnector;
    }

    @Override
    public void initiateRequest(String datasetId, String offerId) {
        this.systemConsumerConnector.getConsumerNegotiationManager().createNegotiation(datasetId, offerId, null);
    }

    @Override
    public void contractOffer(String consumerId, Map<String, Object> offer, String callbackAddress, boolean expectError) {
        this.execute("offer", offer, expectError, compacted -> {
            this.systemConsumerConnector.getConsumerNegotiationManager().handleOffer(compacted);
            return null;
        });
    }

    @Override
    public void contractAgreement(String consumerId, Map<String, Object> agreement, String callbackAddress, boolean expectError) {
        this.execute("agreement", agreement, expectError, compacted -> {
            this.systemConsumerConnector.getConsumerNegotiationManager().handleAgreement(compacted);
            return null;
        });
    }

    @Override
    public void finalize(String consumerId, Map<String, Object> event, String callbackAddress, boolean expectError) {
        this.execute("finalize", event, expectError, compacted -> {
            this.systemConsumerConnector.getConsumerNegotiationManager().handleFinalized(compacted);
            return null;
        });
    }

    @Override
    public Map<String, Object> getNegotiation(String consumerId, String callbackAddress) {
        ContractNegotiation negotiation = this.systemConsumerConnector.getConsumerNegotiationManager().findById(consumerId);
        String consumerPid = negotiation.getCorrelationId();
        return MessageSerializer.processJsonLd((Map)NegotiationFunctions.createNegotiationResponse((String)consumerId, (String)consumerPid, (String)negotiation.getState().toString()));
    }

    @Override
    public void terminate(String counterPartyId, Map<String, Object> termination, String callbackAddress, boolean expectError) {
        this.execute("termination", termination, expectError, compacted -> {
            this.systemConsumerConnector.getConsumerNegotiationManager().handleTermination(compacted);
            return null;
        });
    }
}

