/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.system.client.catalog.http;

import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dsp.system.api.client.catalog.CatalogClient;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;

public class HttpCatalogClient
implements CatalogClient {
    private static final String CATALOG_REQUEST_PATH = "/catalog/request";
    private static final String DATASET_REQUEST_PATH = "/catalog/datasets/%s";
    private final String connectorUnderTestUrl;
    private final Monitor monitor;

    public HttpCatalogClient(String connectorUnderTestUrl, Monitor monitor) {
        this.connectorUnderTestUrl = connectorUnderTestUrl;
        this.monitor = monitor;
    }

    public Map<String, Object> getCatalog(Map<String, Object> message) {
        try (Response response = HttpFunctions.postJson((String)(this.connectorUnderTestUrl + CATALOG_REQUEST_PATH), message, (boolean)false);){
            this.monitor.debug("Received catalog request response");
            Map map = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            return map;
        }
    }

    public Map<String, Object> getDataset(String datasetId, boolean expectError) {
        try (Response response = HttpFunctions.getJson((String)(this.connectorUnderTestUrl + String.format(DATASET_REQUEST_PATH, datasetId)), (boolean)expectError);){
            this.monitor.debug("Received dataset request response");
            Map map = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            return map;
        }
    }
}

