/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import java.util.Map;
import java.util.UUID;
import okhttp3.Response;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;

public class ProviderActions {
    private static final String NEGOTIATION_OFFER_TEMPLATE = "%s/negotiations/%s/offers/";
    private static final String NEGOTIATION_TERMINATE_TEMPLATE = "%s/negotiations/%s/termination/";
    private static final String NEGOTIATION_AGREEMENT_TEMPLATE = "%s/negotiations/%s/agreement";
    private static final String NEGOTIATION_FINALIZE_TEMPLATE = "%s/negotiations/%s/events";

    private ProviderActions() {
    }

    public static void postOffer(ContractNegotiation negotiation) {
        Map contractOffer = NegotiationFunctions.createOffer((String)negotiation.getId(), (String)negotiation.getCorrelationId(), (String)UUID.randomUUID().toString(), (String)UUID.randomUUID().toString(), (String)negotiation.getCounterPartyId(), (String)"TCK_PARTICIPANT");
        negotiation.transition(ContractNegotiation.State.OFFERED);
        String url = String.format(NEGOTIATION_OFFER_TEMPLATE, negotiation.getCallbackAddress(), negotiation.getCorrelationId());
        try (Response response = HttpFunctions.postJson((String)url, (Object)contractOffer);){
            ProviderActions.checkResponse(response);
        }
    }

    public static void postAgreed(ContractNegotiation negotiation) {
        Map agreement = NegotiationFunctions.createAgreement((String)negotiation.getId(), (String)negotiation.getCorrelationId(), (String)UUID.randomUUID().toString(), (String)negotiation.getCounterPartyId(), (String)"TCK_PARTICIPANT", (String)negotiation.getDatasetId(), (String)negotiation.getCallbackAddress());
        negotiation.transition(ContractNegotiation.State.AGREED);
        try (Response response = HttpFunctions.postJson((String)String.format(NEGOTIATION_AGREEMENT_TEMPLATE, negotiation.getCallbackAddress(), negotiation.getCorrelationId()), (Object)agreement);){
            ProviderActions.checkResponse(response);
        }
    }

    public static void postFinalized(ContractNegotiation negotiation) {
        negotiation.transition(ContractNegotiation.State.FINALIZED);
        Map event = NegotiationFunctions.createFinalizedEvent((String)negotiation.getId(), (String)negotiation.getCorrelationId());
        try (Response response = HttpFunctions.postJson((String)String.format(NEGOTIATION_FINALIZE_TEMPLATE, negotiation.getCallbackAddress(), negotiation.getCorrelationId()), (Object)event);){
            ProviderActions.checkResponse(response);
        }
    }

    public static void postTerminate(ContractNegotiation negotiation) {
        Map termination = NegotiationFunctions.createTermination((String)negotiation.getId(), (String)negotiation.getCorrelationId(), (String)"1", (String[])new String[0]);
        try (Response response = HttpFunctions.postJson((String)String.format(NEGOTIATION_TERMINATE_TEMPLATE, negotiation.getCallbackAddress(), negotiation.getCorrelationId()), (Object)termination);){
            ProviderActions.checkResponse(response);
        }
    }

    public static void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkResponse(Response response) {
        if (!response.isSuccessful()) {
            throw new AssertionError((Object)("Unexpected response code: " + response.code()));
        }
    }
}

