/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ProviderNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationProviderTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ProviderActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@Tag(value="base-compliance")
@DisplayName(value="CN_03: Contract request provider negative test scenarios")
public class ContractNegotiationProvider03Test
extends AbstractContractNegotiationProviderTest {
    @MandatoryTest
    @DisplayName(value="CN:03-01: Verify contract request, provider agreement, consumer verified, provider finalized, invalid consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractAgreementMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractVerificationMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:finalized\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_03_01() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postAgreed);
        this.negotiationMock.recordVerifiedAction(ProviderActions::postFinalized);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectAgreementMessage(agreement -> this.consumerConnector.getConsumerNegotiationManager().handleAgreement(agreement)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.AGREED)).expectFinalizedEvent(event -> this.consumerConnector.getConsumerNegotiationManager().handleFinalized(event)).sendVerifiedEvent().thenWaitForState(ContractNegotiation.State.FINALIZED)).thenVerifyProviderState(ContractNegotiation.State.FINALIZED).sendTermination(true)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:03-02: Verify contract request, offer received, invalid consumer verified")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCk->>CUT: ContractVerificationMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_03_02() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        ((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).sendVerifiedEvent(true).execute();
        this.negotiationMock.verify();
    }

    @Test
    @MandatoryTest
    @DisplayName(value="CN:03-03: Verify contract request, offer received, consumer accepted, illegal consumer verified")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:accepted\nCUT-->>TCK: 200 OK\n\nTCk->>CUT: ContractVerificationMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_03_03() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        ((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).acceptLastOffer().sendVerifiedEvent(true).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:03-04: Verify contract request, offer received, consumer counter-offer (x2), provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_03_04() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        this.negotiationMock.recordContractRequestedAction(cn -> {});
        ((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).sendCounterOfferMessage(this.offerId, this.datasetId).sendCounterOfferMessage(this.offerId, this.datasetId, true).execute();
        this.negotiationMock.verify();
    }
}

