/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ProviderNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationProviderTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ProviderActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;

@Tag(value="base-compliance")
@DisplayName(value="CN_02: Contract request provider scenarios")
public class ContractNegotiationProvider02Test
extends AbstractContractNegotiationProviderTest {
    @MandatoryTest
    @DisplayName(value="CN:02-01: Verify contract request, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_02_01() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postTerminate);
        ((ProviderNegotiationPipeline)this.negotiationPipeline.sendRequestMessage(this.datasetId, this.offerId).expectTermination().thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-02: Verify contract request, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_02_02() {
        ((ProviderNegotiationPipeline)this.negotiationPipeline.sendRequestMessage(this.datasetId, this.offerId).sendTermination()).thenVerifyProviderState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-03: Verify contract request, provider agreement, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractAgreementMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_02_03() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postAgreed);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectAgreementMessage(agreement -> this.consumerConnector.getConsumerNegotiationManager().handleAgreement(agreement)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.AGREED)).sendTermination()).thenVerifyProviderState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-04: Verify contract request, offer received, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_02_04() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).sendTermination()).thenVerifyProviderState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-05: Verify contract request, offer received, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_02_05() {
        this.negotiationMock.recordContractRequestedAction(negotiation -> {
            ProviderActions.postOffer(negotiation);
            ProviderActions.pause();
            ProviderActions.postTerminate(negotiation);
        });
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).expectTermination().thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-06: Verify contract request, offer received, consumer accepted, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:accepted\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_02_06() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        this.negotiationMock.recordAgreedAction(ProviderActions::postTerminate);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).acceptLastOffer().expectTermination().thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:02-07: Verify contract request, provider agreement, consumer verified, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractAgreementMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractVerificationMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_02_07() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postAgreed);
        this.negotiationMock.recordVerifiedAction(ProviderActions::postTerminate);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectAgreementMessage(agreement -> this.consumerConnector.getConsumerNegotiationManager().handleAgreement(agreement)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.AGREED)).expectTermination().sendVerifiedEvent().thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }
}

