/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ProviderNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationProviderTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ProviderActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;

@Tag(value="base-compliance")
@DisplayName(value="CN_01: Contract request provider scenarios")
public class ContractNegotiationProvider01Test
extends AbstractContractNegotiationProviderTest {
    @MandatoryTest
    @DisplayName(value="CN:01-01: Verify contract request, offer received, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_01_01() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).sendTermination()).thenVerifyProviderState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:01-02: Verify contract request, offer received, consumer counter-offer, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_01_02() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postTerminate);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).expectTerminationMessage(msg -> this.consumerConnector.getConsumerNegotiationManager().handleTermination(msg))).sendCounterOfferMessage("CD123:ACN0102:456", "ACN0102").thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:01-03: Verify contract request, offer received, consumer accepted, provider agreement, consumer verified, provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractOfferMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:accepted\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractAgreementMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractAgreementVerificationMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:finalized\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_01_03() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postOffer);
        this.negotiationMock.recordAgreedAction(ProviderActions::postAgreed);
        this.negotiationMock.recordVerifiedAction(ProviderActions::postFinalized);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectOfferMessage(offer -> this.consumerConnector.getConsumerNegotiationManager().handleOffer(offer)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.OFFERED)).expectAgreementMessage(agreement -> this.consumerConnector.getConsumerNegotiationManager().handleAgreement(agreement)).acceptLastOffer().thenWaitForState(ContractNegotiation.State.AGREED)).expectFinalizedEvent(event -> this.consumerConnector.getConsumerNegotiationManager().handleFinalized(event)).sendVerifiedEvent().thenWaitForState(ContractNegotiation.State.FINALIZED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN:01-04: Verify contract request, provider agreement, consumer verified, provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (consumer)\nparticipant CUT as Connector Under Test (provider)\n\nTCK->>CUT: ContractRequestMessage\nCUT-->>TCK: ContractNegotiation\n\nCUT->>TCK: ContractAgreementMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractAgreementVerificationMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:finalized\nTCK-->>CUT: 200 OK\n")
    public void cn_01_04() {
        this.negotiationMock.recordContractRequestedAction(ProviderActions::postAgreed);
        this.negotiationMock.recordVerifiedAction(ProviderActions::postFinalized);
        ((ProviderNegotiationPipeline)((ProviderNegotiationPipeline)this.negotiationPipeline.expectAgreementMessage(agreement -> this.consumerConnector.getConsumerNegotiationManager().handleAgreement(agreement)).sendRequestMessage(this.datasetId, this.offerId).thenWaitForState(ContractNegotiation.State.AGREED)).expectFinalizedEvent(event -> this.consumerConnector.getConsumerNegotiationManager().handleFinalized(event)).sendVerifiedEvent().thenWaitForState(ContractNegotiation.State.FINALIZED)).execute();
        this.negotiationMock.verify();
    }
}

