/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.connector.IdGenerator;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ConsumerNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationConsumerTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ConsumerActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;

@Tag(value="base-compliance")
@DisplayName(value="CN_C_03: Contract request consumer negative test scenarios")
public class ContractNegotiationConsumer03Test
extends AbstractContractNegotiationConsumerTest {
    @MandatoryTest
    @DisplayName(value="CN_C:03-01: Verify contract request, invalid provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_01() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        ((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).sendFinalizedEvent(true).thenVerifyConsumerState(ContractNegotiation.State.REQUESTED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:03-02: Verify contract request, offer received, invalid provider agreed")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_02() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.OFFERED)).thenVerifyConsumerState(ContractNegotiation.State.OFFERED).sendAgreementMessage(true).thenVerifyConsumerState(ContractNegotiation.State.OFFERED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:03-03: Verify contract request, offer received, invalid provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_03() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.OFFERED)).sendFinalizedEvent(true).thenVerifyConsumerState(ContractNegotiation.State.OFFERED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:03-04: Verify contract request, offer received, consumer accepted, invalid provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:accepted\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_04() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postAccepted);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectAcceptedEvent(event -> this.providerConnector.getProviderNegotiationManager().handleAccepted(event)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.ACCEPTED)).sendFinalizedEvent(true).thenVerifyConsumerState(ContractNegotiation.State.ACCEPTED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:03-05: Verify contract request, offer received, consumer accepted, invalid provider offer")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:accepted\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_05() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postAccepted);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectAcceptedEvent(event -> this.providerConnector.getProviderNegotiationManager().handleAccepted(event)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.ACCEPTED)).sendOfferMessage(true).thenVerifyConsumerState(ContractNegotiation.State.ACCEPTED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:03-06: Verify contract request, offer received, consumer accepted, provider agreed, invalid provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:accepted\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 4xx ERROR\n")
    public void cn_c_03_06() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postAccepted);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectAcceptedEvent(event -> this.providerConnector.getProviderNegotiationManager().handleAccepted(event)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.ACCEPTED)).sendAgreementMessage().thenWaitForState(ContractNegotiation.State.AGREED)).sendFinalizedEvent(true).thenVerifyConsumerState(ContractNegotiation.State.AGREED).execute();
        this.negotiationMock.verify();
    }
}

