/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.connector.IdGenerator;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ConsumerNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationConsumerTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ConsumerActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;

@Tag(value="base-compliance")
@DisplayName(value="CN_C_02: Contract request consumer scenarios")
public class ContractNegotiationConsumer02Test
extends AbstractContractNegotiationConsumerTest {
    @MandatoryTest
    @DisplayName(value="CN_C:02-01: Verify contract request, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_c_02_01() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).sendTermination()).thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:02-02: Verify contract request, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_c_02_02() {
        this.negotiationMock.recordInitializedAction((url, cn) -> {
            ConsumerActions.postRequest(url, cn);
            ConsumerActions.pause();
            ConsumerActions.postTerminated(url, cn);
        });
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectTerminationMessage(msg -> this.providerConnector.getProviderNegotiationManager().handleTermination(msg))).thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:02-03: Verify contract request, provider agreement, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_c_02_03() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordAgreedAction(ConsumerActions::postTerminated);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectTerminationMessage(msg -> this.providerConnector.getProviderNegotiationManager().handleTermination(msg))).sendAgreementMessage().thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:02-04: Verify contract request, offer received, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_c_02_04() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.OFFERED)).thenVerifyConsumerState(ContractNegotiation.State.OFFERED).sendTermination()).thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:02-05: Verify contract request, offer received, consumer accepted, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:accepted\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_c_02_05() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postAccepted);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectAcceptedEvent(msg -> this.providerConnector.getProviderNegotiationManager().handleAccepted(msg)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.ACCEPTED)).sendTermination()).thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:02-06: Verify contract request, provider agreement, consumer verified, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractVerificationMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_c_02_06() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordAgreedAction(ConsumerActions::postVerification);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectVerifiedMessage(msg -> this.providerConnector.getProviderNegotiationManager().handleVerified(msg)).sendAgreementMessage().thenWaitForState(ContractNegotiation.State.VERIFIED)).sendTermination()).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }
}

