/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.api.system.TestSequenceDiagram;
import org.eclipse.dataspacetck.dsp.system.api.connector.IdGenerator;
import org.eclipse.dataspacetck.dsp.system.api.pipeline.ConsumerNegotiationPipeline;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;
import org.eclipse.dataspacetck.dsp.verification.cn.AbstractContractNegotiationConsumerTest;
import org.eclipse.dataspacetck.dsp.verification.cn.ConsumerActions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Tag;

@Tag(value="base-compliance")
@DisplayName(value="CN_C_01: Contract request consumer scenarios")
public class ContractNegotiationConsumer01Test
extends AbstractContractNegotiationConsumerTest {
    @MandatoryTest
    @DisplayName(value="CN_C:01-01: Verify contract request, offer received, consumer accepted, provider agreed, consumer verified, provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationEventMessage:accepted\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractAgreementVerificationMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 200 OK\n")
    public void cn_c_01_01() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postAccepted);
        this.negotiationMock.recordAgreedAction(ConsumerActions::postVerification);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectAcceptedEvent(event -> this.providerConnector.getProviderNegotiationManager().handleAccepted(event)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.ACCEPTED)).expectVerifiedMessage(verified -> this.providerConnector.getProviderNegotiationManager().handleVerified(verified)).sendAgreementMessage().thenWaitForState(ContractNegotiation.State.VERIFIED)).sendFinalizedEvent().thenVerifyConsumerState(ContractNegotiation.State.FINALIZED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:01-02: Verify contract request, offer received, consumer counter-offer, provider terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractNegotiationTerminationMessage\nCUT-->>TCK: 200 OK\n")
    public void cn_c_01_02() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postOffer);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).sendOfferMessage().thenWaitForState(ContractNegotiation.State.REQUESTED)).sendTermination()).thenWaitForState(ContractNegotiation.State.TERMINATED)).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:01-03: Verify contract request, offer received, consumer terminated")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractOfferMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractNegotiationTerminationMessage\nTCK-->>CUT: 200 OK\n")
    public void cn_c_01_03() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordOfferedAction(ConsumerActions::postTerminated);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectTerminationMessage(msg -> this.providerConnector.getProviderNegotiationManager().handleTermination(msg))).sendOfferMessage().thenWaitForState(ContractNegotiation.State.TERMINATED)).thenVerifyConsumerState(ContractNegotiation.State.TERMINATED).execute();
        this.negotiationMock.verify();
    }

    @MandatoryTest
    @DisplayName(value="CN_C:01-04: Verify contract request, provider agreement, consumer verified, provider finalized")
    @TestSequenceDiagram(value="participant TCK as Technology Compatibility Kit (provider)\nparticipant CUT as Connector Under Test (consumer)\n\nTCK->>CUT: Signal to start negotiation\n\nCUT->>TCK: ContractRequestMessage\nTCK-->>CUT: ContractNegotiation\n\nTCK->>CUT: ContractAgreementMessage\nCUT-->>TCK: 200 OK\n\nCUT->>TCK: ContractAgreementVerificationMessage\nTCK-->>CUT: 200 OK\n\nTCK->>CUT: ContractNegotiationEventMessage:finalized\nCUT-->>TCK: 200 OK\n")
    public void cn_c_01_04() {
        this.negotiationMock.recordInitializedAction(ConsumerActions::postRequest);
        this.negotiationMock.recordAgreedAction(ConsumerActions::postVerification);
        ((ConsumerNegotiationPipeline)((ConsumerNegotiationPipeline)this.negotiationPipeline.expectInitialRequest((request, counterpartyId) -> this.providerConnector.getProviderNegotiationManager().handleContractRequest(request, counterpartyId)).initiateRequest(this.datasetId, IdGenerator.offerIdFromDatasetId((String)this.datasetId)).thenWaitForState(ContractNegotiation.State.REQUESTED)).expectVerifiedMessage(verified -> this.providerConnector.getProviderNegotiationManager().handleVerified(verified)).sendAgreementMessage().thenWaitForState(ContractNegotiation.State.VERIFIED)).sendFinalizedEvent().thenVerifyConsumerState(ContractNegotiation.State.FINALIZED).execute();
        this.negotiationMock.verify();
    }
}

