/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dsp.verification.cn;

import java.io.InputStream;
import java.util.Map;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.message.MessageSerializer;
import org.eclipse.dataspacetck.dsp.system.api.http.HttpFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.JsonLdFunctions;
import org.eclipse.dataspacetck.dsp.system.api.message.NegotiationFunctions;
import org.eclipse.dataspacetck.dsp.system.api.statemachine.ContractNegotiation;

public class ConsumerActions {
    private static final String EVENT_PATH = "%s/negotiations/%s/events";
    private static final String REQUEST_PATH = "%s/negotiations/request";
    private static final String VERIFICATION_PATH = "%s/negotiations/%s/agreement/verification";
    private static final String TERMINATION_PATH = "%s/negotiations/%s/termination";
    private static final String REQUEST_OFFER_PATH = "%s/negotiations/%s/request";

    private ConsumerActions() {
    }

    public static void postRequest(String baseUrl, ContractNegotiation negotiation) {
        String url = String.format(REQUEST_PATH, baseUrl);
        Map contractRequest = NegotiationFunctions.createContractRequest((String)negotiation.getId(), (String)negotiation.getOfferId(), (String)negotiation.getDatasetId(), (String)baseUrl);
        try (Response response = HttpFunctions.postJson((String)url, (Object)contractRequest);){
            ConsumerActions.checkResponse(response);
            assert (response.body() != null);
            Map jsonResponse = MessageSerializer.processJsonLd((InputStream)response.body().byteStream());
            String providerId = JsonLdFunctions.stringIdProperty((String)"https://w3id.org/dspace/2025/1/providerPid", (Map)jsonResponse);
            negotiation.setCorrelationId(providerId, ContractNegotiation.State.REQUESTED);
        }
    }

    public static void postAccepted(String baseUrl, ContractNegotiation negotiation) {
        negotiation.transition(ContractNegotiation.State.ACCEPTED);
        String url = String.format(EVENT_PATH, baseUrl, negotiation.getCorrelationId());
        Map agreement = NegotiationFunctions.createAcceptedEvent((String)negotiation.getCorrelationId(), (String)negotiation.getId());
        try (Response response = HttpFunctions.postJson((String)url, (Object)agreement);){
            ConsumerActions.checkResponse(response);
        }
    }

    public static void postTerminated(String baseUrl, ContractNegotiation negotiation) {
        negotiation.transition(ContractNegotiation.State.TERMINATED);
        String url = String.format(TERMINATION_PATH, baseUrl, negotiation.getCorrelationId());
        Map termination = NegotiationFunctions.createTermination((String)negotiation.getCorrelationId(), (String)negotiation.getId(), (String)"1", (String[])new String[0]);
        try (Response response = HttpFunctions.postJson((String)url, (Object)termination);){
            ConsumerActions.checkResponse(response);
        }
    }

    public static void postOffer(String baseUrl, ContractNegotiation negotiation) {
        Map contractOffer = NegotiationFunctions.createContractRequest((String)negotiation.getId(), (String)negotiation.getCorrelationId(), (String)negotiation.getOfferId(), (String)negotiation.getDatasetId(), null);
        negotiation.transition(ContractNegotiation.State.REQUESTED);
        String url = String.format(REQUEST_OFFER_PATH, baseUrl, negotiation.getCorrelationId());
        try (Response response = HttpFunctions.postJson((String)url, (Object)contractOffer);){
            ConsumerActions.checkResponse(response);
        }
    }

    public static void postVerification(String baseUrl, ContractNegotiation negotiation) {
        negotiation.transition(ContractNegotiation.State.VERIFIED);
        String url = String.format(VERIFICATION_PATH, baseUrl, negotiation.getCorrelationId());
        Map verification = NegotiationFunctions.createVerification((String)negotiation.getCorrelationId(), (String)negotiation.getId());
        try (Response response = HttpFunctions.postJson((String)url, (Object)verification);){
            ConsumerActions.checkResponse(response);
        }
    }

    private static void checkResponse(Response response) {
        if (!response.isSuccessful()) {
            throw new AssertionError((Object)("Unexpected response code: " + response.code()));
        }
    }

    public static void pause() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

