/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.verifier;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import okhttp3.Request;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.dcp.system.annotation.AuthToken;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.IssueCredentials;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.annotation.ThirdParty;
import org.eclipse.dataspacetck.dcp.system.annotation.TriggerEndpoint;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.presentation.verifier.AbstractVerifierPresentationFlowTest;
import org.junit.jupiter.api.DisplayName;

public class PresentationFlowSection4Test
extends AbstractVerifierPresentationFlowTest {
    @Inject
    @ThirdParty
    private KeyService thirdPartyKeyService;

    @DisplayName(value="Verifier should reject an auth token without the Bearer prefix")
    @MandatoryTest
    void presentationResponse_rejectMissingBearerPrefix(@TriggerEndpoint String triggerEndpoint, @AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        String triggerMessage = PresentationFlowSection4Test.createTriggerMessage();
        Request rq = this.createRequest(triggerEndpoint, this.createIdToken(authToken), triggerMessage);
        TestFixtures.executeRequest(rq, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - auth token bound to a different iss/sub")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenInvalidIssuerSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(thirdPartyDid).subject(thirdPartyDid).audience(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String idToken = "Bearer " + this.thirdPartyKeyService.sign(Collections.emptyMap(), claimSet);
        String msg = PresentationFlowSection4Test.createTriggerMessage();
        Request request = this.createRequest(triggerEndpoint, idToken, msg);
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - iss and sub different")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenInvalidSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(thirdPartyDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String authHeader = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - incorrect aud")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenIncorrectAud(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(thirdPartyDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String authHeader = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - sub does not match DID document id")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenIncorrectSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(thirdPartyDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String authHeader = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - nbf in future")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenNbfInFuture(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).notBeforeTime(Date.from(Instant.now().plusSeconds(1000000L))).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String authHeader = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - expired")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenExpired(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().minusSeconds(1000000L))).claim("token", (Object)authToken).build();
        String authHeader = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - jti")
    @IssueCredentials(value={"MembershipCredential"})
    public void verifier_04_03_03_idTokenJtiUsedTwice(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken1, @AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken2, @TriggerEndpoint String triggerEndpoint) {
        String jti = UUID.randomUUID().toString();
        JWTClaimsSet claimSet1 = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(this.verifierDid).jwtID(jti).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken1).build();
        String authHeader1 = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet1);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader1, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert2xxCode);
        JWTClaimsSet claimSet2 = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(this.verifierDid).jwtID(jti).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken2).build();
        String authHeader2 = "Bearer " + this.holderKeyService.sign(Collections.emptyMap(), claimSet2);
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, authHeader2, PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @DisplayName(value="4.3.1 Verifier should reject an ID token that does not contain an access token")
    @MandatoryTest
    @IssueCredentials(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"})
    void verifier_04_03_01_presentationResponse_idTokenNoTokenClaim(@TriggerEndpoint String triggerEndpoint) {
        TestFixtures.executeRequest(this.createRequest(triggerEndpoint, "Bearer " + this.createIdToken(null), PresentationFlowSection4Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }
}

