/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.cs;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.dcp.system.annotation.AuthToken;
import org.eclipse.dataspacetck.dcp.system.annotation.IssueCredentials;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.presentation.cs.AbstractPresentationFlowTest;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DisplayName;

public class PresentationFlowSection5Test
extends AbstractPresentationFlowTest {
    @MandatoryTest
    @DisplayName(value="5.2 Verify Credential Service endpoint discovery")
    public void cs_05_02_endpointDiscovery() {
        DidClient didClient = new DidClient(false);
        DidDocument didDocument = didClient.resolveDocument(this.holderDid);
        Assertions.assertThat((Object)didDocument).isNotNull();
        Assertions.assertThat((String)didDocument.getServiceEntry("CredentialService").serviceEndpoint()).isNotNull();
    }

    @MandatoryTest
    @DisplayName(value="5.3.1 Verify submitting an invalid access token header")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_03_01_accessTokenInvalidHeader(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).build();
        String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
        try {
            Request request = new Request.Builder().url(endpoint + "/presentations/query").header("Authorization", this.createIdToken(authToken)).post(RequestBody.create((String)this.mapper.writeValueAsString((Object)message), (MediaType)MediaType.parse((String)"application/json"))).build();
            TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @MandatoryTest
    @DisplayName(value="5.4 Verify Resolution API invalid token not authorized")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_invalidTokenNotAuthorized() {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).build();
        Request request = this.createPresentationRequest("faketoken", message);
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API request does not contain a scope and presentation definition")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_invalidScopeAndPresentationRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).property("presentationDefinition", TestFixtures.createPresentationDefinition("MembershipCredential")).build();
        Request request = this.createPresentationRequest(authToken, message);
        TestFixtures.executeRequest(request, response -> Assertions.assertThat((int)response.code()).isEqualTo(400));
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.1 Verify Resolution API rejects an empty 'presentationDefinition' object")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_emptyPresentationDefinition(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("presentationDefinition", Map.of()).build();
        TestFixtures.executeRequest(this.createPresentationRequest(authToken, message), TestFixtures::assert4xxCode);
        Map message2 = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("presentationDefinition", null).build();
        TestFixtures.executeRequest(this.createPresentationRequest(authToken, message2), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API rejects an empty (or absent) 'scope' array")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_02_emptyScopeExpect4xx(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of()).build();
        TestFixtures.executeRequest(this.createPresentationRequest(authToken, message), response -> Assertions.assertThat((int)response.code()).isEqualTo(400));
        Map message2 = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").build();
        TestFixtures.executeRequest(this.createPresentationRequest(authToken, message2), response -> Assertions.assertThat((int)response.code()).isEqualTo(400));
    }

    @Disabled
    @MandatoryTest
    @DisplayName(value="5.4.1.1 Verify Resolution API presentation definition request for a MembershipCredential")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_01_presentationRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Disabled
    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API presentation definition less types than requested for a SensitiveDataCredential")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_02_lessTypesThanAuthorizedByTypeRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"}) String authToken) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Disabled
    @MandatoryTest
    @DisplayName(value="5.4.1.1 Verify Resolution API presentation definition request for a MembershipCredential")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_01_invalidPresentationEscalationRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API scope request for a MembershipCredential")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_02_scopeByTypeRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).build();
        Request request = this.createPresentationRequest(authToken, message);
        TestFixtures.executeRequest(request, response -> this.verifyCredentials((Response)response, "MembershipCredential"));
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API with less scopes than requested for a SensitiveDataCredential")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_05_04_01_02_lessScopesThanAuthorizedByTypeRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read")).build();
        Request request = this.createPresentationRequest(authToken, message);
        TestFixtures.executeRequest(request, response -> this.verifyCredentials((Response)response, "SensitiveDataCredential"));
    }

    @MandatoryTest
    @DisplayName(value="5.4.1.2 Verify Resolution API invalid scope escalation request for a SensitiveDataCredential")
    @IssueCredentials(value={"MembershipCredential", "SensitiveDataCredential"})
    public void cs_05_04_01_02_invalidScopeEscalationRequest(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        Map message = DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read")).build();
        Request request = this.createPresentationRequest(authToken, message);
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }
}

