/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.cs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.dcp.system.annotation.AuthToken;
import org.eclipse.dataspacetck.dcp.system.annotation.IssueCredentials;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.presentation.cs.AbstractPresentationFlowTest;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.DisplayName;

public class PresentationFlowSection4Test
extends AbstractPresentationFlowTest {
    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - auth token bound to a different iss/sub")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idTokenInvalidIssuerSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.thirdPartyDid).subject(this.thirdPartyDid).audience(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        String idToken = this.thirdPartyKeyService.sign(Collections.emptyMap(), claimSet);
        try {
            String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
            Request request = new Request.Builder().url(endpoint + "/presentations/query").header("Authorization", "Bearer " + idToken).post(RequestBody.create((String)this.mapper.writeValueAsString(this.createMessage()), (MediaType)MediaType.parse((String)"application/json"))).build();
            TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - iss and sub different")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idTokenInvalidSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.thirdPartyDid).audience(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        TestFixtures.executeRequest(this.createRequest(claimSet, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - incorrect aud")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idtokenIncorrectAud(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        TestFixtures.executeRequest(this.createRequest(claimSet, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - sub does not match DID document id")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idtokenIncorrectSub(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.thirdPartyDid).subject(this.thirdPartyDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        TestFixtures.executeRequest(this.createRequest(claimSet, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - nbf in future")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idtokenNbfInFuture(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).notBeforeTime(Date.from(Instant.now().plusSeconds(1000000L))).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        TestFixtures.executeRequest(this.createRequest(claimSet, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - expired")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idtokenExpired(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().minusSeconds(1000000L))).claim("token", (Object)authToken).build();
        TestFixtures.executeRequest(this.createRequest(claimSet, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="4.3.3 Verify invalid access token - jti")
    @IssueCredentials(value={"MembershipCredential"})
    public void cs_04_03_03_idtokenJtiUsedTwice(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken1, @AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken2) {
        String jti = UUID.randomUUID().toString();
        JWTClaimsSet claimSet1 = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(this.holderDid).jwtID(jti).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken1).build();
        TestFixtures.executeRequest(this.createRequest(claimSet1, this.createMessage()), response -> this.verifyCredentials((Response)response, "MembershipCredential"));
        JWTClaimsSet claimSet2 = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(this.holderDid).jwtID(jti).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken2).build();
        TestFixtures.executeRequest(this.createRequest(claimSet2, this.createMessage()), TestFixtures::assert4xxCode);
    }

    @NotNull
    private Request createRequest(JWTClaimsSet claimSet, Map<String, Object> message) {
        String idToken = this.verifierKeyService.sign(Collections.emptyMap(), claimSet);
        try {
            String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
            return new Request.Builder().url(endpoint + "/presentations/query").header("Authorization", "Bearer " + idToken).post(RequestBody.create((String)this.mapper.writeValueAsString(message), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Map<String, Object> createMessage() {
        return DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).build();
    }
}

