/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.issuer;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Request;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.HolderPid;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.issuance.issuer.AbstractCredentialIssuanceTest;
import org.junit.jupiter.api.DisplayName;

public class CredentialRequestTest
extends AbstractCredentialIssuanceTest {
    @Inject
    @HolderPid
    private String holderPid;

    @MandatoryTest
    @DisplayName(value="6.4.1 IssuerService should accept a CredentialRequest")
    void is_6_4_1_credentialRequest(CredentialService credentialService) {
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request.Builder request = this.createCredentialRequest(token, msg);
        TestFixtures.executeRequest(request.build(), response -> {
            TestFixtures.assert2xxCode(response);
            Assertions.assertThat((String)response.header("Location")).isNotEmpty();
        });
        Awaitility.await().atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofMillis(500L)).untilAsserted(() -> ((AbstractCollectionAssert)Assertions.assertThat((Collection)credentialService.getCredentials()).withFailMessage("Expected to receive a CredentialMessage", new Object[0])).hasSize(2));
    }

    @MandatoryTest
    @DisplayName(value="6.4.2 IssuerService should reject a CredentialRequest without an Authorization header")
    void is_6_4_2_credentialRequest_noAuthHeader() {
        Map msg = this.createCredentialRequestMessage(this.holderDid).build();
        Request.Builder request = this.createCredentialRequest(null, msg);
        TestFixtures.executeRequest(request.build(), TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.3 IssuerService should reject a CredentialRequest where the auth header does not have a Bearer prefix")
    void is_6_4_3_credentialRequest_noBearerPrefix() {
        Map credentialMessage = this.createCredentialRequestMessage(this.holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialRequest(null, credentialMessage).header("Authorization", token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.4 IssuerService should reject a CredentialRequest with an invalid body")
    void is_6_4_4_credentialRequest_invalidBody() {
        Map credentialMessage = this.createCredentialRequestMessage(this.holderPid).build();
        HashMap<String, Object> invalidMessage = new HashMap<String, Object>(credentialMessage);
        invalidMessage.remove("credentials");
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialRequest(token, invalidMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.5 IssuerService should reject a CredentialRequest with an invalid token - wrong signature")
    void is_6_4_5_credentialRequest_tokenSignedWithWrongKey() throws JOSEException {
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        JWTClaimsSet claims = this.createClaims().build();
        String kid = this.holderKeyService.getPublicKey().getKeyID();
        ECKey spoofedKey = (ECKey)new ECKeyGenerator(Curve.P_256).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.ES256).type(JOSEObjectType.JWT);
        header.keyID(String.valueOf(claims.getClaim("iss")) + "#" + spoofedKey.getKeyID());
        SignedJWT signedJwt = new SignedJWT(header.build(), claims);
        signedJwt.sign((JWSSigner)new ECDSASigner(spoofedKey.toECPrivateKey()));
        String token = signedJwt.serialize();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.6 IssuerService should reject a CredentialRequest with an invalid token - expired")
    void is_6_4_6_credentialRequest_tokenExpired() {
        String token = this.createToken(this.createClaims().expirationTime(Date.from(Instant.now().minusSeconds(60L))).build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.7 IssuerService should reject a CredentialRequest with an invalid token - iat in future")
    void is_6_4_7_credentialRequest_iatInFuture() {
        String token = this.createToken(this.createClaims().issueTime(Date.from(Instant.now().plusSeconds(60L))).build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.8 IssuerService should reject a CredentialRequest with an invalid token - nbf in future")
    void is_6_4_8_credentialRequest_nbfViolated() {
        String token = this.createToken(this.createClaims().notBeforeTime(Date.from(Instant.now().plusSeconds(60L))).build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.9 IssuerService should reject a CredentialRequest with an invalid token - incorrect aud")
    void is_6_4_8_credentialRequest_invalidAud(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        String token = this.createToken(this.createClaims().audience(thirdPartyDid).build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.10 IssuerService should reject a CredentialRequest with an invalid token - iss != sub")
    void is_6_4_10_credentialRequest_issNotEqualSub(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        String token = this.createToken(this.createClaims().issuer(thirdPartyDid).build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.11 IssuerService should reject a CredentialRequest with an invalid token - jti already used")
    void is_6_4_11_credentialRequest_jtiAlreadyUsed() {
        String token = this.createToken(this.createClaims().build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        Request request = this.createCredentialRequest(token, msg).build();
        TestFixtures.executeRequest(request, response -> Assertions.assertThat((int)response.code()).isEqualTo(201));
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.4.12 IssuerService should reject a CredentialRequest with a missing holderPid")
    void is_6_4_12_credentialRequest_missingHolderPid() {
        String token = this.createToken(this.createClaims().build());
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        HashMap<String, Object> invalidMessage = new HashMap<String, Object>(msg);
        invalidMessage.remove("holderPid");
        Request request = this.createCredentialRequest(token, invalidMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }
}

