/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.cs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.HolderPid;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.issuance.cs.AbstractCredentialIssuanceTest;
import org.junit.jupiter.api.DisplayName;

public class CredentialIssuanceTest
extends AbstractCredentialIssuanceTest {
    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService should accept expected CredentialMessage")
    void cs_06_05_01_credentialMessage(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert2xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects a CredentialMessage with no auth header")
    void cs_06_05_01_credentialMessage_noAuthHeader(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        Request request = this.createCredentialMessageRequest(null, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects a CredentialMessage where the auth header has no bearer prefix")
    void cs_06_05_01_credentialMessage_missingBearerPrefix(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialMessageRequest(null, credentialMessage).header("Authorization", token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects a CredentialMessage with an invalid message body")
    void cs_06_05_01_credentialMessage_invalidBody(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        HashMap<String, Object> invalidMessage = new HashMap<String, Object>(credentialMessage);
        invalidMessage.remove("holderPid");
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialMessageRequest(token, invalidMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - wrong signing key")
    void cs_06_05_01_credentialMessage_tokenSignedWithWrongKey(@HolderPid String holderPid) throws JOSEException {
        Map msg = this.createCredentialMessage(holderPid).build();
        JWTClaimsSet claims = this.createClaims().build();
        String kid = this.issuerKeyService.getPublicKey().getKeyID();
        ECKey spoofedKey = (ECKey)new ECKeyGenerator(Curve.P_256).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.ES256).type(JOSEObjectType.JWT);
        header.keyID(String.valueOf(claims.getClaim("iss")) + "#" + spoofedKey.getKeyID());
        SignedJWT signedJwt = new SignedJWT(header.build(), claims);
        signedJwt.sign((JWSSigner)new ECDSASigner(spoofedKey.toECPrivateKey()));
        String token = signedJwt.serialize();
        Request request = this.createCredentialMessageRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - token expired")
    void cs_06_05_01_credentialMessage_tokenExpired(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().expirationTime(Date.from(Instant.now().minus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - iat in the future")
    void cs_06_05_01_credentialMessage_iatInFuture(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().issueTime(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - nbf")
    void cs_06_05_01_credentialMessage_nbfViolated(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().notBeforeTime(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - incorrect aud")
    void cs_06_05_01_credentialMessage_incorrectAudience(@HolderPid String holderPid, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().audience(thirdPartyDid).build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - iss != sub")
    void cs_06_05_01_credentialMessage_issNotEqualToSub(@HolderPid String holderPid, @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().issuer(this.issuerDid).subject(thirdPartyDid).build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid auth token - jti used before")
    void cs_06_05_01_credentialMessage_jtiAlreadyUsed(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, response -> Assertions.assertThat((boolean)response.isSuccessful()).isTrue());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.5.1 CredentialService rejects an invalid status string")
    void cs_06_05_01_credentialMessage_invalidStatus(@HolderPid String holderPid) {
        Map credentialMessage = this.createCredentialMessage(holderPid).property("status", (Object)"INVALID_STATUS").build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialMessageRequest(token, credentialMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    private Request.Builder createCredentialMessageRequest(String authToken, Map<String, Object> credentialMessage) {
        String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
        try {
            Request.Builder builder = new Request.Builder().url(endpoint + "/credentials").post(RequestBody.create((String)this.mapper.writeValueAsString(credentialMessage), (MediaType)MediaType.parse((String)"application/json")));
            if (authToken != null) {
                builder.addHeader("Authorization", "Bearer " + authToken);
            }
            return builder;
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private DcpMessageBuilder createCredentialMessage(String holderPid) {
        return DcpMessageBuilder.newInstance().type("CredentialMessage").property("issuerPid", (Object)UUID.randomUUID().toString()).property("holderPid", (Object)holderPid).property("status", (Object)"ISSUED").property("credentials", List.of(Map.of("credentialType", "MembershipCredential", "format", "VC1_0_JWT", "payload", this.membershipCredential.rawCredential()), Map.of("credentialType", "SensitiveDataCredential", "format", "VC1_0_JWT", "payload", this.sensitiveDataCredential.rawCredential())));
    }
}

