/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.verifier;

import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import okhttp3.Request;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.dcp.system.annotation.AuthToken;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.Holder;
import org.eclipse.dataspacetck.dcp.system.annotation.IssueCredentials;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.annotation.TriggerEndpoint;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.cs.Delegates;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.generation.JwtCredentialGenerator;
import org.eclipse.dataspacetck.dcp.system.generation.JwtPresentationGenerator;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.vc.CredentialFormat;
import org.eclipse.dataspacetck.dcp.system.model.vc.MetadataReference;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationService;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.presentation.verifier.AbstractVerifierPresentationFlowTest;
import org.junit.jupiter.api.DisplayName;

public class PresentationFlowSection5Test
extends AbstractVerifierPresentationFlowTest {
    @Inject
    @TriggerEndpoint
    private String triggerEndpoint;

    @DisplayName(value="Verifier should resolve the DID from the prover's ID token")
    @MandatoryTest
    @IssueCredentials(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"})
    void presentationResponse_endpointDiscovery() {
        DidClient didClient = new DidClient(false);
        DidDocument didDocument = didClient.resolveDocument(this.verifierDid);
        Assertions.assertThat((Object)didDocument).isNotNull();
        Assertions.assertThat((String)didDocument.getServiceEntry("CredentialService").serviceEndpoint()).isNotNull();
    }

    @DisplayName(value="5.1 Verifier should accept a valid PresentationResponseMessage")
    @MandatoryTest
    @IssueCredentials(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"})
    void verifier_05_01_presentationResponse_success(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken) {
        String triggerMessage = PresentationFlowSection5Test.createTriggerMessage();
        Request rq = this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), triggerMessage);
        TestFixtures.executeRequest(rq, TestFixtures::assert2xxCode);
    }

    @DisplayName(value="5.4.2.1 Verifier should reject a presentation response message that contains a different credential than requested")
    @MandatoryTest
    @IssueCredentials(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"})
    void verifier_05_04_02_01_presentationResponse_tooFewCredentials(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:SomeOtherCredential:read"}) String authToken) {
        TestFixtures.executeRequest(this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage()), TestFixtures::assert4xxCode);
    }

    @DisplayName(value="5.4.2.2 Verifier should accept a presentation response message that contains more credentials than requested")
    @MandatoryTest
    @IssueCredentials(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"})
    void verifier_05_04_02_02_presentationResponse_tooManyCredentials(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read", "org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"}) String authToken) {
        TestFixtures.executeRequest(this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage()), TestFixtures::assert2xxCode);
    }

    @DisplayName(value="5.4.2.3 Verifier should reject an empty 'presentation' array")
    @MandatoryTest
    void verifier_05_04_02_03_presentationResponse_emptyPresentations(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:SensitiveDataCredential:read"}) String authToken, @Holder CredentialService holderCredentialService) {
        Request request = this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                return Result.success((Object)DcpMessageBuilder.newInstance().type("PresentationResponseMessage").property("presentation", List.of()).build());
            }
        });
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @DisplayName(value="5.4.2.4 Verifier should reject an a presentation where a requested credential is missing")
    @MandatoryTest
    void verifier_05_04_02_04_presentationResponse_emptyCredentials(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @Holder CredentialService holderCredentialService) {
        Request request = this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                return Result.success(this.createPresentation(new VerifiableCredential[0]));
            }
        });
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.3 Verifier should reject Presentations where the holder does not match the credentialSubject.id")
    void verifier_05_04_03_presentationResponse_holderNotEqualSubjectId(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, final @Did(value=RoleType.THIRD_PARTY) String thirdPartyDid, @Holder CredentialService holderCredentialService) {
        Request request = this.createRequest(this.triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                VerifiableCredential cred = this.createCredential().credentialSubject(Map.of("id", thirdPartyDid, "foo", "bar")).build();
                return Result.success(this.createPresentation(cred));
            }
        });
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.3.7 Verifier should reject an expired credential")
    void verifier_05_04_03_07_presentationResponse_expiredCredential(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Holder CredentialService holderCredentialService) {
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                VerifiableCredential cred = this.createCredential().expirationDate(Instant.now().minusSeconds(100L).toString()).build();
                return Result.success(this.createPresentation(cred));
            }
        });
        Request request = this.createRequest(triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.3.6 Verifier should reject Presentations where at least 1 credential is revoked/suspended")
    void verifier_05_04_03_06_presentationResponse_credentialRevoked(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Holder CredentialService holderCredentialService, final CredentialRevocationService credentialRevocationService) {
        final int index = 1;
        credentialRevocationService.setRevoked(index);
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                VerifiableCredential cred = this.createCredential().credentialStatus(MetadataReference.Builder.newInstance().id(UUID.randomUUID().toString()).type("BitstringStatusListEntry").setExtensibleProperty("statusPurpose", (Object)"revocation").setExtensibleProperty("statusListIndex", (Object)String.valueOf(index)).setExtensibleProperty("statusListCredential", (Object)"%s/statuslist/%s".formatted(credentialRevocationService.getAddress(), credentialRevocationService.getCredentialId())).build()).build();
                return Result.success(this.createPresentation(cred));
            }
        });
        Request request = this.createRequest(triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="5.4.3.6 Verifier should reject a credential that is not yet valid")
    void verifier_05_04_03_06_presentationResponse_notYetValidCredential(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Holder CredentialService holderCredentialService) {
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                VerifiableCredential cred = this.createCredential().issuanceDate(Instant.now().plusSeconds(3600L).toString()).build();
                return Result.success(this.createPresentation(cred));
            }
        });
        Request request = this.createRequest(triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="X.X Verifier should reject Presentations where at least 1 credential schema is violated")
    void verifier_x_x_presentationResponse_invalidCredentialSchema(@AuthToken(value={"org.eclipse.dspace.dcp.vc.type:MembershipCredential:read"}) String authToken, @TriggerEndpoint String triggerEndpoint, @Holder CredentialService holderCredentialService, final CredentialRevocationService srv) {
        holderCredentialService.withDelegate((CredentialService)new PresentationProvider(){

            public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
                VerifiableCredential cred = this.createCredential().credentialSubject(Map.of("id", PresentationFlowSection5Test.this.holderDid, "baz", "quazz")).credentialSchema(MetadataReference.Builder.newInstance().type("JsonSchemaValidator2018").id("%s/schema/membership-schema.json".formatted(srv.getAddress())).build()).build();
                return Result.success(this.createPresentation(cred));
            }
        });
        Request request = this.createRequest(triggerEndpoint, "Bearer " + this.createIdToken(authToken), PresentationFlowSection5Test.createTriggerMessage());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    private abstract class PresentationProvider
    implements Delegates.PresentationQuery {
        private PresentationProvider() {
        }

        VerifiableCredential.Builder createCredential() {
            return VerifiableCredential.Builder.newInstance().id(UUID.randomUUID().toString()).issuanceDate(Instant.now().toString()).issuer(PresentationFlowSection5Test.this.issuerDid).type(List.of("MembershipCredential")).credentialSubject(Map.of("id", PresentationFlowSection5Test.this.holderDid, "foo", "bar"));
        }

        Map<String, Object> createPresentation(VerifiableCredential ... credentials) {
            List<VcContainer> containers = Stream.of(credentials).map(cred -> {
                Result rawJwt = new JwtCredentialGenerator(PresentationFlowSection5Test.this.issuerDid, PresentationFlowSection5Test.this.issuerKeyService).generateCredential(cred);
                return new VcContainer((String)rawJwt.getContent(), cred, CredentialFormat.VC1_0_JWT);
            }).toList();
            Result rawPres = new JwtPresentationGenerator(PresentationFlowSection5Test.this.holderDid, PresentationFlowSection5Test.this.holderKeyService).generatePresentation(PresentationFlowSection5Test.this.verifierDid, PresentationFlowSection5Test.this.holderDid, containers);
            return DcpMessageBuilder.newInstance().type("PresentationResponseMessage").property("presentation", List.of((String)rawPres.getContent())).build();
        }
    }
}

