/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.verifier;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.core.system.SystemBootstrapExtension;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.Holder;
import org.eclipse.dataspacetck.dcp.system.annotation.Issuer;
import org.eclipse.dataspacetck.dcp.system.annotation.PresentationFlow;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.extension.ExtendWith;

@PresentationFlow
@ExtendWith(value={SystemBootstrapExtension.class})
public class AbstractVerifierPresentationFlowTest {
    @Inject
    @Did(value=RoleType.VERIFIER)
    protected String verifierDid;
    @Inject
    @Did(value=RoleType.HOLDER)
    protected String holderDid;
    @Inject
    @Holder
    protected KeyService holderKeyService;
    @Inject
    @Did(value=RoleType.ISSUER)
    protected String issuerDid;
    @Inject
    @Issuer
    protected KeyService issuerKeyService;

    @NotNull
    protected static String createTriggerMessage() {
        return "{\n    \"@type\":  \"https://w3id.org/dspace/2024/1/CatalogRequestMessage\",\n    \"https://w3id.org/dspace/v0.8/filter\": {}\n}\n";
    }

    protected String createIdToken(String authToken) {
        JWTClaimsSet.Builder claimSet = new JWTClaimsSet.Builder().issuer(this.holderDid).subject(this.holderDid).audience(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L)));
        if (authToken != null) {
            claimSet.claim("token", (Object)authToken);
        }
        return this.holderKeyService.sign(Collections.emptyMap(), claimSet.build());
    }

    @NotNull
    protected Request createRequest(String triggerEndpoint, String authHeader, String triggerMessage) {
        return new Request.Builder().url(triggerEndpoint).header("Authorization", authHeader).post(RequestBody.create((String)triggerMessage, (MediaType)MediaType.parse((String)"application/json"))).build();
    }
}

