/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.presentation.cs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.core.system.SystemBootstrapExtension;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.PresentationFlow;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.annotation.ThirdParty;
import org.eclipse.dataspacetck.dcp.system.annotation.Verifier;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;

@PresentationFlow
@ExtendWith(value={SystemBootstrapExtension.class})
public class AbstractPresentationFlowTest {
    protected static final String PRESENTATION_EXCHANGE_PREFIX = "https://identity.foundation/";
    protected static final String CLASSPATH_SCHEMA = "classpath:/";
    protected static JsonSchema responseSchema;
    @Inject
    @Did(value=RoleType.VERIFIER)
    protected String verifierDid;
    @Inject
    @Did(value=RoleType.HOLDER)
    protected String holderDid;
    @Inject
    @Did(value=RoleType.THIRD_PARTY)
    protected String thirdPartyDid;
    @Inject
    @Verifier
    protected KeyService verifierKeyService;
    @Inject
    @ThirdParty
    protected KeyService thirdPartyKeyService;
    protected ObjectMapper mapper = new ObjectMapper();

    @BeforeAll
    protected static void setUp() {
        JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012, builder -> builder.schemaMappers(schemaMappers -> schemaMappers.mapPrefix("https://w3id.org/dspace-dcp/v1.0/", CLASSPATH_SCHEMA).mapPrefix(PRESENTATION_EXCHANGE_PREFIX, CLASSPATH_SCHEMA)));
        responseSchema = schemaFactory.getSchema(SchemaLocation.of((String)"https://w3id.org/dspace-dcp/v1.0/presentation/presentation-response-message-schema.json"));
    }

    protected Request createPresentationRequest(String authToken, Map<String, Object> message) {
        String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
        try {
            return new Request.Builder().url(endpoint + "/presentations/query").header("Authorization", "Bearer " + this.createIdToken(authToken)).post(RequestBody.create((String)this.mapper.writeValueAsString(message), (MediaType)MediaType.parse((String)"application/json"))).build();
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected String createIdToken(String authToken) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).audience(this.holderDid).subject(this.verifierDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)authToken).build();
        return this.verifierKeyService.sign(Collections.emptyMap(), claimSet);
    }

    public void verifyCredentials(Response response, String ... expectedTypes) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)response.isSuccessful()).withFailMessage("Request failed: " + response.code(), new Object[0])).isTrue();
        try {
            assert (response.body() != null);
            Map responseMessage = (Map)this.mapper.readValue(response.body().bytes(), Map.class);
            Set schemaResult = responseSchema.validate((JsonNode)this.mapper.convertValue((Object)responseMessage, JsonNode.class));
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)schemaResult).withFailMessage(() -> "Schema validation failed: " + schemaResult.stream().map(ValidationMessage::getMessage).collect(Collectors.joining()))).isEmpty();
            List presentations = (List)responseMessage.get("presentation");
            List<String> credentialTypes = TestFixtures.parseAndVerifyPresentation(presentations, this.verifierDid);
            Assertions.assertThat(credentialTypes).containsOnly((Object[])expectedTypes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

