/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.issuer;

import java.util.Collection;
import okhttp3.Request;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialObject;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.issuance.issuer.AbstractCredentialIssuanceTest;
import org.junit.jupiter.api.DisplayName;

public class IssuerMetadataTest
extends AbstractCredentialIssuanceTest {
    @MandatoryTest
    @DisplayName(value="6.7 Verify correct Issuer Metadata")
    void is_6_7_issuerMetadata() {
        String endpoint = TestFixtures.resolveIssuerServiceEndpoint(this.issuerDid);
        Request request = new Request.Builder().url(endpoint + "/metadata").get().build();
        TestFixtures.executeRequest(request, r -> {
            TestFixtures.assert2xxCode(r);
            IssuerMetadata metadata = TestFixtures.bodyAs(r, IssuerMetadata.class, this.mapper);
            Assertions.assertThat((Object)metadata).isNotNull();
            Assertions.assertThat((String)metadata.type()).isEqualTo("IssuerMetadata");
            Assertions.assertThat((String)metadata.issuer()).isEqualTo(this.issuerDid);
            Assertions.assertThat(metadata.credentialsSupported()).isNotEmpty();
        });
    }

    private record IssuerMetadata(String type, String issuer, Collection<CredentialObject> credentialsSupported) {
    }
}

