/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.issuer;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import okhttp3.Request;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.HolderPid;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.issuer.CredentialStatus;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.issuance.issuer.AbstractCredentialIssuanceTest;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.DisplayName;

public class CredentialRequestStatusTest
extends AbstractCredentialIssuanceTest {
    @Inject
    @HolderPid
    private String holderPid;

    @MandatoryTest
    @DisplayName(value="6.8.1 IssuerService should respond with a status message")
    void is_6_8_1_credentialStatusRequest() {
        String id = this.requestCredentials();
        Request.Builder rq = this.createStatusRequest(id);
        Awaitility.await().atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofSeconds(1L)).untilAsserted(() -> TestFixtures.executeRequest(rq.build(), response -> {
            TestFixtures.assert2xxCode(response);
            String status = TestFixtures.bodyAs(response, CredentialStatus.class, this.mapper).getStatus();
            Assertions.assertThat((String)status).isIn(new Object[]{"ISSUED", "RECEIVED", "REJECTED"});
        }));
    }

    @MandatoryTest
    @DisplayName(value="6.8.2 IssuerService should reject a CredentialRequest without an Authorization header")
    void is_6_8_2_credentialStatusRequest_noAuthHeader() {
        String id = this.requestCredentials();
        Request rq = this.createStatusRequest(id).removeHeader("Authorization").build();
        TestFixtures.executeRequest(rq, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.3 IssuerService should reject a CredentialRequest where the auth header does not have a Bearer prefix")
    void is_6_8_3_credentialStatusRequest_noBearerPrefix() {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createStatusRequest(id, token).header("Authorization", token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.5 IssuerService should reject a CredentialRequest with an invalid token - wrong signature")
    void is_6_8_5_credentialStatusRequest_tokenSignedWithWrongKey() throws JOSEException {
        String id = this.requestCredentials();
        JWTClaimsSet claims = this.createClaims().build();
        String kid = this.holderKeyService.getPublicKey().getKeyID();
        ECKey spoofedKey = (ECKey)new ECKeyGenerator(Curve.P_256).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.ES256).type(JOSEObjectType.JWT);
        header.keyID(String.valueOf(claims.getClaim("iss")) + "#" + spoofedKey.getKeyID());
        SignedJWT signedJwt = new SignedJWT(header.build(), claims);
        signedJwt.sign((JWSSigner)new ECDSASigner(spoofedKey.toECPrivateKey()));
        String token = signedJwt.serialize();
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.6 IssuerService should reject a CredentialRequest with an invalid token - expired")
    void is_6_8_6_credentialStatusRequest_tokenExpired() {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().expirationTime(Date.from(Instant.now().minusSeconds(60L))).build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.7 IssuerService should reject a CredentialRequest with an invalid token - iat in future")
    void is_6_8_7_credentialStatusRequest_iatInFuture() {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().issueTime(Date.from(Instant.now().plusSeconds(60L))).build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.8 IssuerService should reject a CredentialRequest with an invalid token - nbf in future")
    void is_6_8_8_credentialStatusRequest_nbfViolated() {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().notBeforeTime(Date.from(Instant.now().plusSeconds(60L))).build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.9 IssuerService should reject a CredentialRequest with an invalid token - incorrect aud")
    void is_6_8_8_credentialStatusRequest_invalidAud(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().audience(thirdPartyDid).build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.10 IssuerService should reject a CredentialRequest with an invalid token - iss != sub")
    void is_6_8_10_credentialStatusRequest_issNotEqualSub(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().issuer(thirdPartyDid).build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.11 IssuerService should reject a CredentialRequest with an invalid token - jti already used")
    void is_6_8_11_credentialStatusRequest_jtiAlreadyUsed() {
        String id = this.requestCredentials();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createStatusRequest(id, token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert2xxCode);
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.8.12 IssuerService should respond with 4xx if the request ID is not found")
    void is_6_8_12_credentialStatusRequest_requestIdNotFound() {
        String token = this.createToken(this.createClaims().build());
        Request request = this.createStatusRequest("not-exist", token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @NotNull
    private Request.Builder createStatusRequest(String id) {
        return new Request.Builder().url(TestFixtures.resolveIssuerServiceEndpoint(this.issuerDid) + "/requests/" + id).header("Authorization", "Bearer " + this.createToken(this.createClaims().build())).get();
    }

    @NotNull
    private Request.Builder createStatusRequest(String id, String token) {
        return new Request.Builder().url(TestFixtures.resolveIssuerServiceEndpoint(this.issuerDid) + "/requests/" + id).header("Authorization", "Bearer " + token).get();
    }

    private String requestCredentials() {
        Map msg = this.createCredentialRequestMessage(this.holderPid).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialRequest(token, msg).build();
        return TestFixtures.executeRequestAndGet(request, response -> {
            TestFixtures.assert2xxCode(response);
            String location = response.headers().get("Location");
            Assertions.assertThat((String)location).isNotNull();
            return location.substring(location.lastIndexOf(47) + 1);
        });
    }
}

