/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.issuer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.core.system.SystemBootstrapExtension;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.Holder;
import org.eclipse.dataspacetck.dcp.system.annotation.IssuerService;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialObject;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.junit.jupiter.api.extension.ExtendWith;

@IssuerService
@ExtendWith(value={SystemBootstrapExtension.class})
public abstract class AbstractCredentialIssuanceTest {
    protected final ObjectMapper mapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    @Inject
    @Did(value=RoleType.HOLDER)
    protected String holderDid;
    @Inject
    @Holder
    protected KeyService holderKeyService;
    @Inject
    @Did(value=RoleType.ISSUER)
    protected String issuerDid;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected DcpMessageBuilder createCredentialRequestMessage(String holderPid) {
        String endpoint = TestFixtures.resolveIssuerServiceEndpoint(this.issuerDid);
        Request.Builder builder = new Request.Builder().header("Authorization", "Bearer " + this.createToken(this.createClaims().build())).url(endpoint + "/metadata").get();
        try (Response response = new OkHttpClient().newCall(builder.build()).execute();){
            if (!response.isSuccessful()) throw new AssertionError((Object)("Expected IssuerMetadata to return 200 OK, but got " + response.code()));
            String stream = response.body().string();
            IssuerMetadataMessage issuerMetadata = (IssuerMetadataMessage)this.mapper.readValue(stream, IssuerMetadataMessage.class);
            List<Map> ids = issuerMetadata.getCredentialsSupported().stream().filter(co -> co.getProfile().equals("vc11-sl2021/jwt")).map(CredentialObject::getId).map(id -> Map.of("id", id)).toList();
            DcpMessageBuilder dcpMessageBuilder = DcpMessageBuilder.newInstance().type("CredentialRequestMessage").property("holderPid", (Object)holderPid).property("credentials", ids);
            return dcpMessageBuilder;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Request.Builder createCredentialRequest(String authToken, Map<String, Object> credentialRequestMessage) {
        String endpoint = TestFixtures.resolveIssuerServiceEndpoint(this.issuerDid);
        try {
            Request.Builder builder = new Request.Builder().url(endpoint + "/credentials").post(RequestBody.create((String)this.mapper.writeValueAsString(credentialRequestMessage), (MediaType)MediaType.parse((String)"application/json")));
            if (authToken != null) {
                builder.addHeader("Authorization", "Bearer " + authToken);
            }
            return builder;
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected JWTClaimsSet.Builder createClaims() {
        return new JWTClaimsSet.Builder().audience(this.issuerDid).issuer(this.holderDid).subject(this.holderDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L)));
    }

    protected String createToken(JWTClaimsSet claims) {
        return this.holderKeyService.sign(Collections.emptyMap(), claims);
    }

    private static class IssuerMetadataMessage {
        private String type;
        private String issuer;
        private Collection<CredentialObject> credentialsSupported;

        private IssuerMetadataMessage() {
        }

        public String getType() {
            return this.type;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public Collection<CredentialObject> getCredentialsSupported() {
            return this.credentialsSupported;
        }
    }
}

