/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.cs;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.gen.ECKeyGenerator;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.api.system.MandatoryTest;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.verification.fixtures.TestFixtures;
import org.eclipse.dataspacetck.dcp.verification.issuance.cs.AbstractCredentialIssuanceTest;
import org.junit.jupiter.api.DisplayName;

public class CredentialOfferTest
extends AbstractCredentialIssuanceTest {
    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService should accept CredentialOfferMessage")
    void cs_06_06_01_credentialOfferMessage() {
        Map msg = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialOfferMessageRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert2xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService should accept CredentialOfferMessage (only IDs)")
    void cs_06_06_01_credentialOfferMessage_onlyIds() {
        Map msg = this.createCredentialOfferMessage().property("credentials", List.of(Map.of("id", UUID.randomUUID().toString()), Map.of("id", UUID.randomUUID().toString()))).build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialOfferMessageRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert2xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects a CredentialOfferMessage with no auth header")
    void cs_06_06_01_credentialOfferMessage_noAuthHeader() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        Request request = this.createCredentialOfferMessageRequest(null, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects a CredentialOfferMessage where the auth header has no bearer prefix")
    void cs_06_06_01_credentialOfferMessage_missingBearerPrefix() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialOfferMessageRequest(null, credentialOfferMessage).header("Authorization", token).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects a CredentialOfferMessage with an invalid message body")
    void cs_06_06_01_credentialOfferMessage_invalidBody() {
        Map message = this.createCredentialOfferMessage().property("issuer", null).build();
        HashMap<String, Object> invalidMessage = new HashMap<String, Object>(message);
        invalidMessage.remove("holderPid");
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialOfferMessageRequest(token, invalidMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - wrong signing key")
    void cs_06_06_01_credentialOfferMessage_tokenSignedWithWrongKey() throws JOSEException {
        Map msg = this.createCredentialOfferMessage().build();
        JWTClaimsSet claims = this.createClaims().build();
        String kid = this.issuerKeyService.getPublicKey().getKeyID();
        ECKey spoofedKey = (ECKey)new ECKeyGenerator(Curve.P_256).keyID(kid).keyUse(KeyUse.SIGNATURE).generate();
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.ES256).type(JOSEObjectType.JWT);
        header.keyID(String.valueOf(claims.getClaim("iss")) + "#" + spoofedKey.getKeyID());
        SignedJWT signedJwt = new SignedJWT(header.build(), claims);
        signedJwt.sign((JWSSigner)new ECDSASigner(spoofedKey.toECPrivateKey()));
        String token = signedJwt.serialize();
        Request request = this.createCredentialOfferMessageRequest(token, msg).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - token expired")
    void cs_06_06_01_credentialOfferMessage_tokenExpired() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().expirationTime(Date.from(Instant.now().minus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - iat in the future")
    void cs_06_06_01_credentialOfferMessage_iatInFuture() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().issueTime(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - nbf")
    void cs_06_06_01_credentialOfferMessage_nbfViolated() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().notBeforeTime(Date.from(Instant.now().plus(1L, ChronoUnit.HOURS))).build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - incorrect aud")
    void cs_06_06_01_credentialOfferMessage_incorrectAudience(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().audience(thirdPartyDid).build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - iss != sub")
    void cs_06_06_01_credentialOfferMessage_issNotEqualToSub(@Did(value=RoleType.THIRD_PARTY) String thirdPartyDid) {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().issuer(this.issuerDid).subject(thirdPartyDid).build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    @MandatoryTest
    @DisplayName(value="6.6.1 CredentialService rejects an invalid auth token - jti used before")
    void cs_06_06_01_credentialOfferMessage_jtiAlreadyUsed() {
        Map credentialOfferMessage = this.createCredentialOfferMessage().build();
        String token = this.createToken(this.createClaims().build());
        Request request = this.createCredentialOfferMessageRequest(token, credentialOfferMessage).build();
        TestFixtures.executeRequest(request, response -> Assertions.assertThat((boolean)response.isSuccessful()).isTrue());
        TestFixtures.executeRequest(request, TestFixtures::assert4xxCode);
    }

    private Request.Builder createCredentialOfferMessageRequest(String authToken, Map<String, Object> credentialOfferMessage) {
        String endpoint = TestFixtures.resolveCredentialServiceEndpoint(this.holderDid);
        try {
            Request.Builder builder = new Request.Builder().url(endpoint + "/offers").post(RequestBody.create((String)this.mapper.writeValueAsString(credentialOfferMessage), (MediaType)MediaType.parse((String)"application/json")));
            if (authToken != null) {
                builder.addHeader("Authorization", "Bearer " + authToken);
            }
            return builder;
        }
        catch (JsonProcessingException e) {
            throw new AssertionError((Object)e);
        }
    }

    private DcpMessageBuilder createCredentialOfferMessage() {
        return DcpMessageBuilder.newInstance().type("CredentialOfferMessage").property("issuer", (Object)this.issuerDid).property("credentials", List.of(Map.of("id", UUID.randomUUID().toString(), "type", "CredentialObject", "credentialType", "MembershipCredential", "offerReason", "reissue", "bindingMethods", List.of("did:web:"), "profiles", List.of("vc11-sl2021/jwt", "vc20-bssl/jwt"), "issuancePolicy", Map.of())));
    }
}

