/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.issuance.cs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.eclipse.dataspacetck.core.api.system.Inject;
import org.eclipse.dataspacetck.core.system.SystemBootstrapExtension;
import org.eclipse.dataspacetck.dcp.system.annotation.Credential;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.IssuanceFlow;
import org.eclipse.dataspacetck.dcp.system.annotation.Issuer;
import org.eclipse.dataspacetck.dcp.system.annotation.RoleType;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.junit.jupiter.api.extension.ExtendWith;

@IssuanceFlow
@ExtendWith(value={SystemBootstrapExtension.class})
public class AbstractCredentialIssuanceTest {
    protected final ObjectMapper mapper = new ObjectMapper();
    @Inject
    @Did(value=RoleType.ISSUER)
    protected String issuerDid;
    @Inject
    @Did(value=RoleType.HOLDER)
    protected String holderDid;
    @Inject
    @Credential(value="MembershipCredential")
    protected VcContainer membershipCredential;
    @Inject
    @Credential(value="SensitiveDataCredential")
    protected VcContainer sensitiveDataCredential;
    @Inject
    @Issuer
    protected KeyService issuerKeyService;

    protected JWTClaimsSet.Builder createClaims() {
        return new JWTClaimsSet.Builder().audience(this.holderDid).issuer(this.issuerDid).subject(this.issuerDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L)));
    }

    protected String createToken(JWTClaimsSet claims) {
        return this.issuerKeyService.sign(Collections.emptyMap(), claims);
    }
}

