/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.verification.fixtures;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.dataspacetck.dcp.system.crypto.Keys;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.did.VerificationMethod;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.jetbrains.annotations.NotNull;

public class TestFixtures {
    public static void executeRequest(Request request, Consumer<Response> verification) {
        OkHttpClient client = new OkHttpClient();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            verification.accept(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T executeRequestAndGet(Request request, Function<Response, T> verification) {
        OkHttpClient client = new OkHttpClient();
        Call call = client.newCall(request);
        try (Response response = call.execute();){
            Response t = verification.apply(response);
            return (T)t;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> createPresentationDefinition(String credentialType) {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("path", List.of("$.type"));
        fields.put("filter", Map.of("type", "string", "pattern", credentialType));
        HashMap<String, Object> descriptor = new HashMap<String, Object>();
        descriptor.put("id", "credential");
        descriptor.put("format", "vcdm11_jwt");
        descriptor.put("constraints", Map.of("fields", fields));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", UUID.randomUUID().toString());
        map.put("input_descriptors", List.of(descriptor));
        return map;
    }

    public static void assert4xxCode(Response response) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)response.code()).withFailMessage("Expected a 4xx client error HTTP code but got %s".formatted(response.code()), new Object[0])).isBetween(Integer.valueOf(400), Integer.valueOf(500));
        Assertions.assertThat((boolean)response.isSuccessful()).isFalse();
    }

    public static VerificationMethod resolveKeyMaterial(String kid) {
        String[] kidTokens = kid.split("#");
        if (kidTokens.length != 2) {
            throw new AssertionError((Object)("Key material must have two parts: [documentId]#[keyId], but was: " + kid));
        }
        DidClient didClient = new DidClient(false);
        DidDocument document = didClient.resolveDocument(kidTokens[0]);
        Result vm = document.getVerificationMethod("#" + kidTokens[1]);
        if (vm.failed()) {
            throw new AssertionError((Object)("Key material could not be resolved: " + vm.getFailure()));
        }
        return (VerificationMethod)vm.getContent();
    }

    public static String resolveCredentialServiceEndpoint(String holderDid) {
        DidClient didClient = new DidClient(false);
        DidDocument document = didClient.resolveDocument(holderDid);
        return document.getServiceEntry("CredentialService").serviceEndpoint();
    }

    public static String resolveIssuerServiceEndpoint(String holderDid) {
        DidClient didClient = new DidClient(false);
        DidDocument document = didClient.resolveDocument(holderDid);
        return document.getServiceEntry("IssuerService").serviceEndpoint();
    }

    public static List<String> parseAndVerifyPresentation(List<String> presentations, String audience) {
        return presentations.stream().flatMap(vp -> {
            try {
                SignedJWT parsedVp = TestFixtures.parseAndVerifyJwt(vp);
                JWTClaimsSet claims = parsedVp.getJWTClaimsSet();
                List aud = claims.getAudience();
                Assertions.assertThat((List)aud).isNotNull();
                Assertions.assertThat((List)aud).containsOnly((Object[])new String[]{audience});
                List<Map<String, Object>> presentationList = TestFixtures.objectOrMap(parsedVp.getJWTClaimsSet().getClaim("vp"));
                List<String> credentialJwts = presentationList.stream().map(pres -> pres.get("verifiableCredential")).map(o -> (List)o).flatMap(Collection::stream).toList();
                return TestFixtures.parseAndVerifyCredentials(credentialJwts);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }).toList();
    }

    private static List<Map<String, Object>> objectOrMap(Object vpClaim) {
        if (vpClaim instanceof Map) {
            return List.of((Map)vpClaim);
        }
        if (vpClaim instanceof Collection) {
            return (List)vpClaim;
        }
        throw new IllegalArgumentException("Unsupported type: " + vpClaim.getClass().getName());
    }

    public static Stream<String> parseAndVerifyCredentials(List<String> credentialJwts) {
        return credentialJwts.stream().flatMap(jwt -> {
            try {
                SignedJWT parsedVc = TestFixtures.parseAndVerifyJwt(jwt);
                Map vc = (Map)parsedVc.getJWTClaimsSet().getClaim("vc");
                return ((List)vc.get("type")).stream();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @NotNull
    private static SignedJWT parseAndVerifyJwt(String jwt) {
        try {
            SignedJWT parsedVc = SignedJWT.parse((String)jwt);
            String kid = parsedVc.getHeader().getKeyID();
            VerificationMethod material = TestFixtures.resolveKeyMaterial(kid);
            JWK jwk = JWK.parse((Map)material.getPublicKeyJwk());
            JWSVerifier vcVerifier = Keys.createVerifier((PublicKey)jwk.toECKey().toPublicKey());
            Assertions.assertThat((boolean)parsedVc.verify(vcVerifier)).isTrue();
            return parsedVc;
        }
        catch (JOSEException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static void assert2xxCode(Response response) {
        Assertions.assertThat((int)response.code()).isBetween(Integer.valueOf(200), Integer.valueOf(300));
        Assertions.assertThat((boolean)response.isSuccessful()).isTrue();
    }

    public static <T> T bodyAs(Response response, Class<T> type, ObjectMapper objectMapper) {
        try {
            return (T)objectMapper.readValue(response.body().byteStream(), type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

