/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.verifier;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.handler.AbstractProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.vc.MetadataReference;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationService;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.util.Parsers;
import org.eclipse.dataspacetck.dcp.system.util.Validators;
import org.eclipse.dataspacetck.dcp.system.verifier.PresentationResponseMessage;
import org.jetbrains.annotations.NotNull;

public class VerifierTriggerHandler
extends AbstractProtocolHandler {
    private final TokenValidationService tokenService;
    private final ObjectMapper objectMapper;
    private final OkHttpClient httpClient;
    private final KeyService keyService;
    private final String verifierDid;
    private final TokenValidationService credentialValidationService;
    private final CredentialRevocationService credentialRevocationService;

    public VerifierTriggerHandler(TokenValidationService tokenService, ObjectMapper objectMapper, KeyService keyService, String verifierDid, TokenValidationService credentialValidationService, CredentialRevocationService credentialRevocationService) {
        super("/credential-schemas/membership-credential-schema.json");
        this.tokenService = tokenService;
        this.objectMapper = objectMapper;
        this.keyService = keyService;
        this.verifierDid = verifierDid;
        this.credentialValidationService = credentialValidationService;
        this.credentialRevocationService = credentialRevocationService;
        this.httpClient = new OkHttpClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HandlerResponse apply(Map<String, List<String>> headers, InputStream body) {
        List<String> tokenHeaders = headers.get("Authorization");
        if (tokenHeaders == null) return new HandlerResponse(401, "");
        if (tokenHeaders.isEmpty()) {
            return new HandlerResponse(401, "");
        }
        String unparsedToken = tokenHeaders.get(0);
        if (!Validators.validateBearerTokenHeader(unparsedToken)) {
            return new HandlerResponse(401, "");
        }
        String idToken = Parsers.parseBearerToken(unparsedToken);
        Result<JWT> jwtResult = this.tokenService.validateToken(idToken);
        if (jwtResult.failed()) {
            return new HandlerResponse(401, "");
        }
        JWT jwt = (JWT)jwtResult.getContent();
        try {
            String accessToken = jwt.getJWTClaimsSet().getClaimAsString("token");
            String bearerDid = jwt.getJWTClaimsSet().getIssuer();
            String verifierIdToken = this.createIdToken(accessToken, bearerDid);
            String endpoint = this.resolveCredentialServiceEndpoint(bearerDid);
            Request presentationQueryRequest = new Request.Builder().url(endpoint + "/presentations/query").header("Authorization", "Bearer " + verifierIdToken).post(RequestBody.create((String)this.objectMapper.writeValueAsString(this.createPresentationMessage()), (MediaType)MediaType.parse((String)"application/json"))).build();
            try (Response response = this.httpClient.newCall(presentationQueryRequest).execute();){
                if (response.isSuccessful()) {
                    PresentationResponseMessage presentationResponse = (PresentationResponseMessage)this.objectMapper.readValue(response.body().byteStream(), PresentationResponseMessage.class);
                    HandlerResponse handlerResponse2 = this.verifyPresentationResponse(presentationResponse);
                    return handlerResponse2;
                }
                HandlerResponse handlerResponse = this.toHandlerResponse(response);
                return handlerResponse;
            }
        }
        catch (IOException | ParseException e) {
            return new HandlerResponse(401, e.getMessage());
        }
    }

    private HandlerResponse verifyPresentationResponse(PresentationResponseMessage presentationResponse) {
        if (presentationResponse.presentations().isEmpty()) {
            return new HandlerResponse(401, "empty presentation array");
        }
        try {
            for (String presentation : presentationResponse.presentations()) {
                Result<JWT> result = this.tokenService.validateToken(presentation);
                if (result.failed()) {
                    return new HandlerResponse(401, result.getFailure());
                }
                JWTClaimsSet presentationClaims = ((JWT)result.getContent()).getJWTClaimsSet();
                if (!presentationClaims.getAudience().contains(this.verifierDid)) {
                    return new HandlerResponse(401, "missing audience: " + this.verifierDid);
                }
                if (!presentationClaims.getIssuer().equals(presentationClaims.getSubject())) {
                    return new HandlerResponse(401, "iss != sub");
                }
                Map vpToken = ((JWT)result.getContent()).getJWTClaimsSet().getJSONObjectClaim("vp");
                if (vpToken == null) {
                    return new HandlerResponse(401, "missing 'vp' claim");
                }
                List credentials = (List)vpToken.get("verifiableCredential");
                if (credentials.isEmpty()) {
                    return new HandlerResponse(401, "No credentials received");
                }
                for (String credential : credentials) {
                    Result<Void> credentialResult = this.validateCredential(presentationClaims.getIssuer(), credential);
                    if (!credentialResult.failed()) continue;
                    return new HandlerResponse(401, credentialResult.getFailure());
                }
            }
            return new HandlerResponse(200, "");
        }
        catch (ParseException e) {
            return new HandlerResponse(401, e.getMessage());
        }
    }

    @NotNull
    private Result<Void> validateCredential(String presentationHolder, String credential) {
        Result<JWT> tokenResult = this.credentialValidationService.validateToken(credential);
        if (tokenResult.failed()) {
            return Result.failure((String)tokenResult.getFailure());
        }
        try {
            Object index;
            int ix;
            boolean status;
            VerifiableCredential vc = (VerifiableCredential)this.objectMapper.convertValue((Object)((JWT)tokenResult.getContent()).getJWTClaimsSet().getJSONObjectClaim("vc"), VerifiableCredential.class);
            Boolean match = Optional.ofNullable(vc.getCredentialSubject().get("id")).map(Object::toString).map(id -> id.equals(presentationHolder)).orElse(true);
            if (!match.booleanValue()) {
                return Result.failure((String)"Not all credential subject IDs match the holder ID");
            }
            if (vc.getExpirationDate() != null && Instant.parse(vc.getExpirationDate()).isBefore(Instant.now())) {
                return Result.failure((String)"Credential is expired");
            }
            if (Instant.parse(vc.getIssuanceDate()).isAfter(Instant.now())) {
                return Result.failure((String)"Credential is not yet valid");
            }
            if (vc.getCredentialStatus() != null && (status = this.credentialRevocationService.isRevoked(ix = Integer.parseInt((index = vc.getCredentialStatus().getExtensibleProperties().get("statusListIndex")).toString())))) {
                return Result.failure((String)"Credential is revoked");
            }
            Boolean isValidSchema = Optional.ofNullable(vc.getCredentialSchema()).map(MetadataReference::getId).map(credentialSchemaUrl -> {
                Set validationMessages = this.schema.validate((JsonNode)this.objectMapper.convertValue((Object)vc.getCredentialSubject(), JsonNode.class));
                return validationMessages.isEmpty();
            }).orElse(true);
            if (!isValidSchema.booleanValue()) {
                return Result.failure((String)"Credential schema validation failed");
            }
        }
        catch (ParseException e) {
            return Result.failure((String)e.getMessage());
        }
        return Result.success();
    }

    private String createIdToken(String accessToken, String audience) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(this.verifierDid).subject(this.verifierDid).audience(audience).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).claim("token", (Object)accessToken).build();
        return this.keyService.sign(Collections.emptyMap(), claimSet);
    }

    private HandlerResponse toHandlerResponse(Response response) {
        if (response.isSuccessful()) {
            return new HandlerResponse(200, "");
        }
        return new HandlerResponse(response.code(), response.message());
    }

    private Map<String, Object> createPresentationMessage() {
        return DcpMessageBuilder.newInstance().type("PresentationQueryMessage").property("scope", List.of("org.eclipse.dspace.dcp.vc.type:MembershipCredential:read")).build();
    }

    private String resolveCredentialServiceEndpoint(String bearerDid) {
        DidClient didClient = new DidClient(false);
        DidDocument document = didClient.resolveDocument(bearerDid);
        return document.getServiceEntry("CredentialService").serviceEndpoint();
    }
}

