/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.verifier;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.PublicKey;
import java.text.ParseException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.dataspacetck.dcp.system.crypto.Keys;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.did.VerificationMethod;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.jetbrains.annotations.NotNull;

public class BaseTokenValidationService
implements TokenValidationService {
    private final Map<String, String> usedJts = new ConcurrentHashMap<String, String>();

    @Override
    public Result<JWT> validateToken(String credentialToken) {
        try {
            SignedJWT jwt = SignedJWT.parse((String)credentialToken);
            JWTClaimsSet claims = jwt.getJWTClaimsSet();
            Result<VerificationMethod> verificationMethod = this.validateClaims(claims, jwt.getHeader());
            if (verificationMethod.failed()) {
                return Result.failure((String)verificationMethod.getFailure());
            }
            return this.verifySignature(jwt, (VerificationMethod)verificationMethod.getContent());
        }
        catch (JOSEException | ParseException e) {
            return Result.failure((String)("Invalid JWT: " + e.getMessage()));
        }
    }

    @NotNull
    protected Result<VerificationMethod> validateClaims(JWTClaimsSet claims, JWSHeader header) throws ParseException, JOSEException {
        VerificationMethod method;
        String kid = header.getKeyID();
        String jti = claims.getJWTID();
        if (jti == null) {
            return Result.failure((String)"JTI not specified");
        }
        if (this.usedJts.containsKey(jti)) {
            return Result.failure((String)"JTI already used");
        }
        this.usedJts.put(jti, jti);
        if (claims.getExpirationTime() == null) {
            return Result.failure((String)"Expiration not specified");
        }
        if (claims.getExpirationTime().before(new Date())) {
            return Result.failure((String)"Token has expired");
        }
        if (claims.getIssueTime() == null) {
            return Result.failure((String)"IAT not specified");
        }
        if (claims.getIssueTime().after(new Date())) {
            return Result.failure((String)"Token issued in the future");
        }
        if (claims.getNotBeforeTime() != null && claims.getNotBeforeTime().after(new Date())) {
            return Result.failure((String)"Token used before start");
        }
        String[] parts = kid.split("#");
        if (parts.length != 1 && parts.length != 2) {
            return Result.failure((String)("Invalid kid: " + kid));
        }
        String issuerDid = parts[0];
        DidClient client = new DidClient(false);
        DidDocument didDocument = client.resolveDocument(issuerDid);
        if (parts.length == 1) {
            if (didDocument.getVerificationMethods().size() != 1) {
                return Result.failure((String)"Since no key id was specified, the DID document must have exactly one verification method");
            }
            method = (VerificationMethod)didDocument.getVerificationMethods().get(0);
        } else {
            Result result = didDocument.getVerificationMethod("#" + parts[1]);
            if (result.failed()) {
                return Result.failure((String)result.getFailure());
            }
            method = (VerificationMethod)result.getContent();
        }
        return Result.success((Object)method);
    }

    @NotNull
    protected Result<JWT> verifySignature(SignedJWT jwt, VerificationMethod method) throws ParseException, JOSEException {
        JWK key = JWK.parse((Map)method.getPublicKeyJwk());
        boolean result = jwt.verify(Keys.createVerifier((PublicKey)key.toECKey().toPublicKey()));
        return result ? Result.success((Object)jwt) : Result.failure((String)"JWT verification failed");
    }
}

