/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.revocation;

import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.revocation.BitString;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationService;

public class StatusList2021Service
implements CredentialRevocationService {
    public static final String REVOCATION = "revocation";
    private static final int LENGTH = 16384;
    private final BitString bitstring = BitString.Builder.newInstance().size(16384).build();
    private final String credentialId = UUID.randomUUID().toString();
    private final String issuerDid;
    private final String address;

    public StatusList2021Service(String issuerDid, String address) {
        this.issuerDid = issuerDid;
        this.address = address;
    }

    @Override
    public void setRevoked(int statusListIndex) {
        if (statusListIndex >= 16384 || statusListIndex < 0) {
            throw new IndexOutOfBoundsException("Index out of range: " + statusListIndex);
        }
        this.bitstring.set(statusListIndex, true);
    }

    @Override
    public VerifiableCredential createStatusListCredential() {
        VerifiableCredential.Builder credential = ((VerifiableCredential.Builder)VerifiableCredential.Builder.newInstance().id(this.credentialId).type(List.of("VerifiableCredential", "StatusList2021Credential")).issuer(this.issuerDid).issuanceDate(Instant.now().toString()).context(List.of("https://www.w3.org/2018/credentials/v1", "https://w3id.org/vc/status-list/2021/v1"))).credentialSubject(Map.of("id", this.credentialId, "type", "StatusList2021", "statusPurpose", REVOCATION, "encodedList", this.generateEncodedStatusList()));
        return credential.build();
    }

    @Override
    public String getCredentialId() {
        return this.credentialId;
    }

    @Override
    public boolean isRevoked(int statusListIndex) {
        return this.bitstring.get(statusListIndex);
    }

    public String generateEncodedStatusList() {
        return "u" + (String)BitString.Writer.newInstance().encoder(Base64.getUrlEncoder().withoutPadding()).write(this.bitstring).getContent();
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getStatusEntryType() {
        return "StatusList2021Entry";
    }
}

