/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.revocation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.zip.GZIPOutputStream;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class BitString {
    private final boolean leftToRightIndexing;
    private final byte[] bits;
    private final int bitsPerByte = 8;

    private BitString(byte[] bits, boolean leftToRightIndexing) {
        this.bits = bits;
        this.leftToRightIndexing = leftToRightIndexing;
    }

    public boolean get(int idx) {
        if (idx < 0 || idx >= this.length()) {
            throw new IllegalArgumentException("Index out of range 0-%s".formatted(this.length()));
        }
        int byteIdx = idx / 8;
        int shift = this.bitPosition(idx);
        return ((long)this.bits[byteIdx] & 1L << shift) != 0L;
    }

    public void set(int idx, boolean status) {
        if (idx < 0 || idx >= this.length()) {
            throw new IllegalArgumentException("Index out of range 0-%s".formatted(this.length()));
        }
        int byteIdx = idx / 8;
        int shift = this.bitPosition(idx);
        if (status) {
            int n = byteIdx;
            this.bits[n] = (byte)(this.bits[n] | (byte)(1L << shift));
        } else {
            int n = byteIdx;
            this.bits[n] = (byte)(this.bits[n] & (byte)(1L << shift ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public int length() {
        return this.bits.length * 8;
    }

    private int bitPosition(int idx) {
        int bitIdx = idx % 8;
        return this.leftToRightIndexing ? 7 - bitIdx : bitIdx;
    }

    public static final class Writer {
        private Base64.Encoder encoder = Base64.getEncoder();

        private Writer() {
        }

        public static Writer newInstance() {
            return new Writer();
        }

        public Writer encoder(Base64.Encoder encoder) {
            this.encoder = encoder;
            return this;
        }

        public Result<String> write(BitString bitString) {
            Result<byte[]> compressed = this.compress(bitString.bits);
            if (compressed.failed()) {
                return Result.failure((String)compressed.getFailure());
            }
            try {
                return Result.success((Object)this.encoder.encodeToString((byte[])compressed.getContent()));
            }
            catch (Exception e) {
                return Result.failure((String)e.getMessage());
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private Result<byte[]> compress(byte[] bytes) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                Result result;
                try (GZIPOutputStream zipStream = new GZIPOutputStream(outputStream);){
                    zipStream.write(bytes);
                    zipStream.close();
                    result = Result.success((Object)outputStream.toByteArray());
                }
                return result;
            }
            catch (IOException e) {
                return Result.failure((String)"Failed to gzip the input bytes: %s".formatted(e.getMessage()));
            }
        }
    }

    public static final class Builder {
        private boolean leftToRightIndexing = true;
        private int size = 131072;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder leftToRightIndexing(boolean leftToRightIndexing) {
            this.leftToRightIndexing = leftToRightIndexing;
            return this;
        }

        public Builder size(int size) {
            this.size = size;
            return this;
        }

        public BitString build() {
            if (this.size % 8 != 0) {
                throw new IllegalArgumentException("BitString size should be multiple of 8");
            }
            byte[] bits = new byte[this.size / 8];
            return new BitString(bits, this.leftToRightIndexing);
        }
    }
}

