/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.issuer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialMessage;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialObject;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.generation.JwtCredentialGenerator;
import org.eclipse.dataspacetck.dcp.system.issuer.CredentialRequestMessage;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerService;
import org.eclipse.dataspacetck.dcp.system.model.vc.CredentialFormat;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class IssuerServiceImpl
implements IssuerService {
    private final KeyService issuerKeyService;
    private final TokenValidationService issuerTokenValidationService;
    private final ObjectMapper objectMapper;
    private final Map<String, RequestStatus> credentialRequests = new HashMap<String, RequestStatus>();
    private final Map<String, CredentialObject> supportedCredentials;
    private final Map<String, CredentialFormat> supportedCredentialFormats = Map.of("vc11-sl2021/jwt", CredentialFormat.VC1_0_JWT, "vc20-bssl/jwt", CredentialFormat.VC2_0_JOSE);

    public IssuerServiceImpl(KeyService issuerKeyService, TokenValidationService issuerTokenValidationService, Map<String, CredentialObject> supportedCredentials) {
        this.issuerKeyService = issuerKeyService;
        this.issuerTokenValidationService = issuerTokenValidationService;
        this.supportedCredentials = supportedCredentials;
        this.objectMapper = new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public Result<String> processCredentialRequest(String idTokenJwt, Map<String, Object> credentialRequestMessage) {
        String holderDid;
        String issuerDid;
        Result<JWT> validationResult = this.issuerTokenValidationService.validateToken(idTokenJwt);
        if (!validationResult.succeeded()) {
            return Result.failure((String)validationResult.getFailure(), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        JWT jwt = (JWT)validationResult.getContent();
        try {
            issuerDid = (String)jwt.getJWTClaimsSet().getAudience().get(0);
            holderDid = jwt.getJWTClaimsSet().getIssuer();
        }
        catch (ParseException e) {
            return Result.failure((String)("Error parsing holder's token: " + e.getMessage()), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        JwtCredentialGenerator gen = new JwtCredentialGenerator(issuerDid, this.issuerKeyService);
        CredentialRequestMessage credentialRequest = (CredentialRequestMessage)this.objectMapper.convertValue(credentialRequestMessage, CredentialRequestMessage.class);
        if (!credentialRequest.validate()) {
            return Result.failure((String)"Invalid credential request message", (Result.ErrorType)Result.ErrorType.BAD_REQUEST);
        }
        String correlation = credentialRequest.getHolderPid();
        List<CredentialMessage.CredentialContainer> credentials = credentialRequest.getCredentials().stream().map(cred -> {
            CredentialObject descriptor = this.supportedCredentials.get(cred.id());
            if (descriptor == null) {
                throw new IllegalArgumentException("No CredentialObject found for id: " + cred.id());
            }
            CredentialFormat format = this.supportedCredentialFormats.get(descriptor.getProfile());
            return new CredentialMessage.CredentialContainer(descriptor.getCredentialType(), (String)this.generateJwtCredential(descriptor.getCredentialType(), gen, holderDid, issuerDid).getContent(), format.name());
        }).toList();
        String issuerPid = UUID.randomUUID().toString();
        CredentialMessage credentialsMessage = CredentialMessage.Builder.newInstance().holderPid(correlation).issuerPid(issuerPid).status("ISSUED").credentials(credentials).build();
        this.credentialRequests.put(issuerPid, new RequestStatus(credentialRequest, "RECEIVED"));
        this.sendBackCredentials(holderDid, issuerDid, credentialsMessage);
        return Result.success((Object)issuerPid);
    }

    public Result<Map<String, String>> getCredentialStatus(String idTokenJwt, String id) {
        Result<JWT> validationResult = this.issuerTokenValidationService.validateToken(idTokenJwt);
        if (!validationResult.succeeded()) {
            return Result.failure((String)validationResult.getFailure(), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        return Optional.ofNullable(this.credentialRequests.get(id)).map(rqs -> Result.success(Map.of("type", "CredentialStatus", "holderPid", rqs.credentialRequest.getHolderPid(), "issuerPid", id, "status", rqs.status.toUpperCase()))).orElseGet(() -> Result.failure((String)"No credential request found", (Result.ErrorType)Result.ErrorType.NOT_FOUND));
    }

    private Result<String> generateJwtCredential(String type, JwtCredentialGenerator gen, String holderDid, String issuerDid) {
        return gen.generateCredential(VerifiableCredential.Builder.newInstance().credentialSubject(Map.of("id", holderDid)).id(UUID.randomUUID().toString()).issuanceDate(Instant.now().toString()).issuer(issuerDid).type(List.of(type)).credentialSubject(Map.of("id", holderDid, "bar", "baz")).build());
    }

    private void sendBackCredentials(String holderDid, String issuerDid, CredentialMessage credentialsMsg) {
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.schedule(() -> {
            String body;
            JWTClaimsSet claims = new JWTClaimsSet.Builder().audience(holderDid).issuer(issuerDid).subject(issuerDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).build();
            String token = this.issuerKeyService.sign(Collections.emptyMap(), claims);
            DidClient didClient = new DidClient(false);
            String endpoint = didClient.resolveDocument(holderDid).getServiceEntry("CredentialService").serviceEndpoint();
            try {
                body = this.objectMapper.writeValueAsString((Object)credentialsMsg);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            Request rq = new Request.Builder().url(endpoint + "/credentials").header("Authorization", "Bearer " + token).post(RequestBody.create((String)body, (MediaType)MediaType.parse((String)"application/json"))).build();
            try {
                Response ignored = new OkHttpClient().newCall(rq).execute();
                if (ignored != null) {
                    ignored.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, 500L, TimeUnit.MILLISECONDS);
        scheduledExecutorService.shutdown();
    }

    private record RequestStatus(CredentialRequestMessage credentialRequest, String status) {
    }
}

