/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.issuer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.core.api.system.ProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialObject;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;

public class IssuerMetadataHandler
implements ProtocolHandler {
    private final Map<String, CredentialObject> supportedCredentials;
    private final ObjectMapper mapper;
    private final String issuerDid;

    public IssuerMetadataHandler(Map<String, CredentialObject> supportedCredentials, ObjectMapper mapper, String issuerDid) {
        this.supportedCredentials = supportedCredentials;
        this.mapper = mapper;
        this.issuerDid = issuerDid;
    }

    public HandlerResponse apply(Map<String, List<String>> map, InputStream inputStream) {
        Map body = DcpMessageBuilder.newInstance().type("IssuerMetadata").property("issuer", (Object)this.issuerDid).property("credentialsSupported", this.supportedCredentials.values()).build();
        try {
            String bodyJson = this.mapper.writeValueAsString((Object)body);
            return new HandlerResponse(200, bodyJson);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

