/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.issuer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.core.api.system.ProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerService;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class CredentialRequestHandler
implements ProtocolHandler {
    private final IssuerService issuerService;
    private final ObjectMapper objectMapper;

    public CredentialRequestHandler(IssuerService issuerService, ObjectMapper objectMapper) {
        this.issuerService = issuerService;
        this.objectMapper = objectMapper;
    }

    public HandlerResponse apply(Map<String, List<String>> headers, InputStream body) {
        throw new RuntimeException("Not implemented");
    }

    public HandlerResponse apply(String path, Map<String, List<String>> headers, InputStream body) {
        List<String> authHeaders = headers.get("Authorization");
        if (authHeaders == null || authHeaders.isEmpty() || authHeaders.get(0).isEmpty() || !authHeaders.get(0).startsWith("Bearer ")) {
            return new HandlerResponse(401, "Missing access token");
        }
        String id = path.substring(path.lastIndexOf("/") + 1);
        String idToken = headers.get("Authorization").get(0);
        Result result = this.issuerService.getCredentialStatus(idToken = idToken.replace("Bearer", "").trim(), id);
        if (result.succeeded()) {
            try {
                String json = this.objectMapper.writeValueAsString(result.getContent());
                return new HandlerResponse(200, json);
            }
            catch (JsonProcessingException e) {
                return new HandlerResponse(400, "Failed to serialize CredentialStatus");
            }
        }
        return switch (result.getErrorType()) {
            default -> throw new IncompatibleClassChangeError();
            case Result.ErrorType.BAD_REQUEST -> new HandlerResponse(400, result.getFailure());
            case Result.ErrorType.UNAUTHORIZED -> new HandlerResponse(401, result.getFailure());
            case Result.ErrorType.NOT_FOUND -> new HandlerResponse(404, result.getFailure());
            case Result.ErrorType.GENERAL_ERROR, Result.ErrorType.NO_ERROR -> new HandlerResponse(500, result.getFailure());
        };
    }
}

