/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.generation;

import com.nimbusds.jwt.JWTClaimsSet;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.generation.PresentationGenerator;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class JwtPresentationGenerator
implements PresentationGenerator {
    private final String issuerDid;
    private final KeyService keyService;

    public JwtPresentationGenerator(String issuerDid, KeyService keyService) {
        this.keyService = keyService;
        this.issuerDid = issuerDid;
    }

    @Override
    public PresentationGenerator.PresentationFormat getFormat() {
        return PresentationGenerator.PresentationFormat.JWT;
    }

    @Override
    public Result<String> generatePresentation(String audience, String holderDid, List<VcContainer> credentials) {
        Date now = new Date();
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(this.issuerDid).audience(audience).subject(holderDid).jwtID(UUID.randomUUID().toString()).notBeforeTime(now).issueTime(now).expirationTime(Date.from(now.toInstant().plusSeconds(300L))).claim("vp", this.createVpToken(credentials)).build();
        String keyId = this.issuerDid + "#" + this.keyService.getPublicKey().getKeyID();
        return Result.success((Object)this.keyService.sign(Map.of("kid", keyId), claims));
    }

    private Map<String, Object> createVpToken(List<VcContainer> credentials) {
        return Map.of("context", List.of("https://www.w3.org/2018/credentials/v1", "https://identity.foundation/presentation-exchange/submission/v1"), "type", "VerifiablePresentation", "verifiableCredential", credentials.stream().map(VcContainer::rawCredential).toList());
    }
}

