/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.generation;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.generation.CredentialGenerator;
import org.eclipse.dataspacetck.dcp.system.model.vc.CredentialFormat;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class JwtCredentialGenerator
implements CredentialGenerator {
    private final String issuerDid;
    private KeyService keyService;

    public JwtCredentialGenerator(String issuerDid, KeyService keyService) {
        this.issuerDid = issuerDid;
        this.keyService = keyService;
    }

    @Override
    public CredentialFormat getFormat() {
        return CredentialFormat.VC1_0_JWT;
    }

    @Override
    public Result<String> generateCredential(VerifiableCredential credential) {
        Date now = new Date();
        if (!this.issuerDid.equals(credential.getIssuer())) {
            throw new RuntimeException(String.format("Credential issuer '%s' not equal to issuer DID: %s", credential.getIssuer(), this.issuerDid));
        }
        JWTClaimsSet claims = new JWTClaimsSet.Builder().issuer(this.issuerDid).subject(credential.getId()).claim("jti", (Object)UUID.randomUUID()).notBeforeTime(now).issueTime(now).expirationTime(Date.from(Instant.now().plusSeconds(300L))).claim("vc", (Object)credential.toMap()).build();
        String keyId = this.issuerDid + "#" + this.keyService.getPublicKey().getKeyID();
        return Result.success((Object)this.keyService.sign(Map.of("kid", keyId), claims));
    }
}

