/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.did;

import java.util.List;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.did.DidService;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.did.ServiceEntry;
import org.eclipse.dataspacetck.dcp.system.model.did.VerificationMethod;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class DidServiceImpl
implements DidService {
    protected final String did;
    protected final String baseEndpoint;
    protected final KeyService keyService;

    public DidServiceImpl(String did, String baseEndpoint, KeyService keyService) {
        this.did = did;
        this.baseEndpoint = baseEndpoint;
        this.keyService = keyService;
    }

    public Result<DidDocument> resolveDidDocument() {
        DidDocument document = this.createDocumentBuilder().build();
        return Result.success((Object)document);
    }

    protected DidDocument.Builder createDocumentBuilder() {
        return ((DidDocument.Builder)DidDocument.Builder.newInstance().id(this.did).context(List.of("https://www.w3.org/ns/did/v1", "https://w3id.org/dspace-dcp/v1.0"))).service(List.of(new ServiceEntry("TCK-Credential-Service", "CredentialService", this.baseEndpoint))).verificationMethod(List.of(VerificationMethod.Builder.newInstance().id(this.did + "#" + this.keyService.getPublicKey().getKeyID()).type("JsonWebKey2020").controller(this.did).publicKeyJwk(this.keyService.getPublicKey().toJSONObject()).build()));
    }
}

