/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.did;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.function.Function;
import org.eclipse.dataspacetck.dcp.system.did.DidService;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public record DidDocumentHandler(DidService didService, ObjectMapper mapper) implements Function<InputStream, String>
{
    @Override
    public String apply(InputStream inputStream) {
        try {
            Result result = this.didService.resolveDidDocument();
            if (result.failed()) {
                throw new RuntimeException("Error resolving DID document: " + result.getFailure());
            }
            return this.mapper.writeValueAsString(result.getContent());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

