/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.List;
import org.eclipse.dataspacetck.dcp.system.model.did.VerificationMethod;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.verifier.BaseTokenValidationService;
import org.jetbrains.annotations.NotNull;

public class TokenValidationServiceImpl
extends BaseTokenValidationService {
    private final String audience;

    public TokenValidationServiceImpl(String audience) {
        this.audience = audience;
    }

    @Override
    @NotNull
    protected Result<VerificationMethod> validateClaims(JWTClaimsSet claims, JWSHeader header) throws ParseException, JOSEException {
        List aud = claims.getAudience();
        if (aud.isEmpty()) {
            return Result.failure((String)"Audience is empty");
        }
        if (!aud.contains(this.audience)) {
            return Result.failure((String)("Audience does not match: " + String.valueOf(aud)));
        }
        if (!claims.getIssuer().equals(claims.getSubject())) {
            return Result.failure((String)"Issuer and subject do not match");
        }
        return super.validateClaims(claims, header);
    }
}

