/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.eclipse.dataspacetck.core.spi.system.ServiceConfiguration;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.sts.SecureTokenServer;
import org.jetbrains.annotations.NotNull;

public class SecureTokenServerImpl
implements SecureTokenServer {
    private final Map<String, String> readTokens = new ConcurrentHashMap<String, String>();
    private final String stsUrl;
    private final String stsClientId;
    private final String stsClientSecret;
    private final ObjectMapper objectMapper = new ObjectMapper();

    public SecureTokenServerImpl(ServiceConfiguration configuration) {
        this.stsUrl = configuration.getPropertyAsString("dataspacetck.sts.url", null);
        this.stsClientId = configuration.getPropertyAsString("dataspacetck.sts.client.id", null);
        this.stsClientSecret = configuration.getPropertyAsString("dataspacetck.sts.client.secret", null);
    }

    @Override
    public Result<String> obtainReadToken(String bearerDid, List<String> scopes) {
        if (this.stsUrl == null) {
            String types = this.transformScopes(scopes);
            String token = String.valueOf(UUID.randomUUID()) + "::" + bearerDid + "::" + types;
            this.readTokens.put(token, token);
            return Result.success((Object)token);
        }
        String scopeString = String.join((CharSequence)" ", scopes);
        if (this.stsClientId == null || this.stsClientSecret == null) {
            return Result.failure((String)"When overriding the STS URL, client ID and secret must be provided");
        }
        return this.requestRemoteAccessToken(this.stsUrl, this.stsClientId, this.stsClientSecret, bearerDid, scopeString);
    }

    @Override
    public Result<String> obtainWriteToken(String bearerDid, String audience, KeyService keyService) {
        return Result.success((Object)this.authorizeWrite(keyService, bearerDid, UUID.randomUUID().toString(), audience));
    }

    @Override
    public Result<List<String>> validateReadToken(String bearerDid, String token) {
        if (this.readTokens.remove(token) == null) {
            return Result.failure((String)"Token not valid");
        }
        String[] parts = token.split("::");
        if (parts.length != 3) {
            return Result.failure((String)"Invalid token format");
        }
        if (!parts[1].equals(bearerDid)) {
            return Result.failure((String)"Token binding not valid");
        }
        return Result.success(Arrays.asList(parts[2].split(",")));
    }

    @Override
    public String authorizeWrite(KeyService keyService, String bearerDid, String correlationId, String audience) {
        JWTClaimsSet claims = new JWTClaimsSet.Builder().audience(audience).issuer(bearerDid).subject(bearerDid).jwtID(correlationId).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).build();
        return keyService.sign(Collections.emptyMap(), claims);
    }

    @Override
    public Result<Void> validateWrite(String serializedJwt, TokenValidationService tokenValidationService) {
        Result<JWT> validationResult = tokenValidationService.validateToken(serializedJwt);
        if (validationResult.succeeded()) {
            return Result.success();
        }
        return Result.failure((String)("Token not valid: " + validationResult.getFailure()));
    }

    @NotNull
    private String transformScopes(List<String> scopes) {
        return scopes.stream().map(scope -> {
            if (!scope.startsWith("org.eclipse.dspace.dcp.vc.type:")) {
                throw new IllegalArgumentException("Invalid scope: " + scope);
            }
            return scope.substring("org.eclipse.dspace.dcp.vc.type:".length());
        }).collect(Collectors.joining(","));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result<String> requestRemoteAccessToken(String stsUrl, String stsClientId, String stsClientSecret, String audience, String scopes) {
        Request rq = new Request.Builder().url(stsUrl + "/token").addHeader("Content-Type", "application/x-www-form-urlencoded").post((RequestBody)new FormBody.Builder().add("grant_type", "client_credentials").add("client_id", stsClientId).add("client_secret", stsClientSecret).add("audience", audience).add("bearer_access_scope", scopes).build()).build();
        OkHttpClient client = new OkHttpClient();
        try (Response response = client.newCall(rq).execute();){
            ResponseBody body;
            if (response.isSuccessful() && (body = response.body()) != null) {
                String token = ((Map)this.objectMapper.readValue(body.string(), Map.class)).get("access_token").toString();
                String tokenClaim = SignedJWT.parse((String)token).getJWTClaimsSet().getClaim("token").toString();
                Result result2 = Result.success((Object)tokenClaim);
                return result2;
            }
            Result result = Result.failure((String)("Request failed with HTTP code " + response.code()));
            return result;
        }
        catch (IOException e) {
            return Result.failure((String)("Error requesting token: " + e.getMessage()));
        }
        catch (ParseException e) {
            return Result.failure((String)("Failed to parse token: " + e.getMessage()));
        }
    }
}

