/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.ValidationMessage;
import com.nimbusds.jwt.JWT;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.handler.AbstractProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.util.Parsers;
import org.eclipse.dataspacetck.dcp.system.util.Validators;

public class PresentationHandler
extends AbstractProtocolHandler {
    private final CredentialService credentialService;
    private final TokenValidationService tokenService;
    private final ObjectMapper mapper;
    private final Monitor monitor;

    public PresentationHandler(CredentialService credentialService, TokenValidationService tokenService, ObjectMapper mapper, Monitor monitor) {
        super("/presentation/presentation-query-message-schema.json");
        this.credentialService = credentialService;
        this.tokenService = tokenService;
        this.mapper = mapper;
        this.monitor = monitor;
    }

    public HandlerResponse apply(Map<String, List<String>> headers, InputStream body) {
        try {
            Map message = (Map)this.mapper.readValue(body, Map.class);
            if (!"PresentationQueryMessage".equals(message.get("type")) && !"PresentationQueryMessage".equals(message.get("@type"))) {
                this.monitor.enableError().message(String.format("Message is not a %s", "PresentationQueryMessage"));
                return new HandlerResponse(400, "");
            }
            List<String> tokenHeaders = headers.get("Authorization");
            if (tokenHeaders == null || tokenHeaders.isEmpty()) {
                return new HandlerResponse(401, "");
            }
            String unparsedToken = tokenHeaders.get(0);
            if (!Validators.validateBearerTokenHeader(unparsedToken)) {
                return new HandlerResponse(401, "");
            }
            String idToken = Parsers.parseBearerToken(unparsedToken);
            Result<JWT> jwtResult = this.tokenService.validateToken(idToken);
            if (jwtResult.failed()) {
                return new HandlerResponse(401, "");
            }
            JWT jwt = (JWT)jwtResult.getContent();
            String accessToken = jwt.getJWTClaimsSet().getClaimAsString("token");
            Set schemaResult = this.schema.validate((JsonNode)this.mapper.convertValue((Object)message, JsonNode.class));
            if (!schemaResult.isEmpty()) {
                String error = String.format("Schema validation failed: %s", schemaResult.stream().map(ValidationMessage::getMessage).collect(Collectors.joining("\n")));
                this.monitor.enableError().message(error).resetMode();
                return new HandlerResponse(400, error);
            }
            String issuer = jwt.getJWTClaimsSet().getIssuer();
            Result result = this.credentialService.presentationQueryMessage(issuer, accessToken, message);
            if (result.succeeded()) {
                return new HandlerResponse(200, this.mapper.writeValueAsString(result.getContent()));
            }
            int code = switch (result.getErrorType()) {
                case Result.ErrorType.NOT_FOUND -> 404;
                case Result.ErrorType.UNAUTHORIZED -> 401;
                case Result.ErrorType.BAD_REQUEST -> 400;
                default -> {
                    this.monitor.enableError().message(String.format("%s failed: %s", "PresentationQueryMessage", result.getFailure())).resetMode();
                    yield 500;
                }
            };
            return new HandlerResponse(code, "");
        }
        catch (IOException e) {
            throw new AssertionError(String.format("Error handling %s", "PresentationQueryMessage"), e);
        }
        catch (ParseException e) {
            throw new AssertionError("Invalid access token", e);
        }
    }
}

