/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.SignedJWT;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialMessage;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialOfferMessage;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.generation.PresentationGenerator;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.system.model.vc.CredentialFormat;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.sts.SecureTokenServer;
import org.jetbrains.annotations.NotNull;

public class CredentialServiceImpl
implements CredentialService {
    public static final Pattern SCOPE_PATTERN = Pattern.compile("(org.eclipse.dspace.dcp.vc.type):(?<type>.*):(.*)");
    private final SecureTokenServer secureTokenServer;
    private final String holderDid;
    private final Map<PresentationGenerator.PresentationFormat, PresentationGenerator> generators;
    private final Map<String, List<VcContainer>> credentialsByType = new ConcurrentHashMap<String, List<VcContainer>>();
    private final TokenValidationService tokenService;
    private final ObjectMapper mapper;
    private CredentialService delegate;

    public CredentialServiceImpl(String holderDid, List<PresentationGenerator> generators, SecureTokenServer secureTokenServer, TokenValidationService tokenService, ObjectMapper mapper) {
        this.generators = generators.stream().collect(Collectors.toMap(PresentationGenerator::getFormat, v -> v));
        this.holderDid = holderDid;
        this.secureTokenServer = secureTokenServer;
        this.tokenService = tokenService;
        this.mapper = mapper;
    }

    public Result<Map<String, Object>> presentationQueryMessage(String bearerDid, String accessToken, Map<String, Object> message) {
        if (this.delegate != null) {
            return this.delegate.presentationQueryMessage(bearerDid, accessToken, message);
        }
        Result<List<String>> validationResult = this.secureTokenServer.validateReadToken(bearerDid, accessToken);
        if (validationResult.failed()) {
            return Result.failure((String)validationResult.getFailure(), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        if (message.containsKey("presentationDefinition") && message.containsKey("scope")) {
            return Result.failure((String)"Request cannot contain both a scope and presentation definition", (Result.ErrorType)Result.ErrorType.BAD_REQUEST);
        }
        List scopes = (List)validationResult.getContent();
        return message.containsKey("presentationDefinition") ? this.processPresentationQuery(message, scopes, bearerDid) : this.processScopeQuery(message, scopes, bearerDid);
    }

    public Result<Void> writeCredentials(String idTokenJwt, Map<String, Object> credentialMessage) {
        if (this.delegate != null) {
            return this.delegate.writeCredentials(idTokenJwt, credentialMessage);
        }
        Result<Void> validationResult = this.secureTokenServer.validateWrite(idTokenJwt, this.tokenService);
        if (validationResult.failed()) {
            return Result.failure((String)validationResult.getFailure(), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        return this.storeCredentials(credentialMessage);
    }

    public Result<Void> offerCredentials(String idTokenJwt, InputStream body) {
        if (this.delegate != null) {
            return this.delegate.offerCredentials(idTokenJwt, body);
        }
        Result<Void> validationResult = this.secureTokenServer.validateWrite(idTokenJwt, this.tokenService);
        if (validationResult.failed()) {
            return Result.failure((String)validationResult.getFailure(), (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        try {
            CredentialOfferMessage message = (CredentialOfferMessage)this.mapper.readValue(body, CredentialOfferMessage.class);
            if (!message.validate()) {
                return Result.failure((String)"Invalid message", (Result.ErrorType)Result.ErrorType.BAD_REQUEST);
            }
            return Result.success();
        }
        catch (IOException e) {
            return Result.failure((String)("Invalid JSON: " + e.getMessage()), (Result.ErrorType)Result.ErrorType.BAD_REQUEST);
        }
    }

    public Collection<VcContainer> getCredentials() {
        if (this.delegate != null) {
            return this.delegate.getCredentials();
        }
        return this.credentialsByType.values().stream().flatMap(Collection::stream).toList();
    }

    public void withDelegate(CredentialService delegate) {
        this.delegate = delegate;
    }

    @NotNull
    private Result<Void> storeCredentials(Map<String, Object> credentialMessage) {
        CredentialMessage message = (CredentialMessage)this.mapper.convertValue(credentialMessage, CredentialMessage.class);
        if (!message.validate()) {
            return Result.failure((String)"Invalid message", (Result.ErrorType)Result.ErrorType.BAD_REQUEST);
        }
        message.getCredentials().forEach(cred -> {
            VcContainer container = new VcContainer(cred.payload(), this.createCredential((CredentialMessage.CredentialContainer)cred), CredentialFormat.valueOf((String)cred.format()));
            this.credentialsByType.computeIfAbsent(cred.credentialType(), k -> new ArrayList()).add(container);
        });
        return Result.success();
    }

    private VerifiableCredential createCredential(CredentialMessage.CredentialContainer cred) {
        try {
            Map claims = (Map)SignedJWT.parse((String)cred.payload()).getJWTClaimsSet().getClaim("vc");
            return (VerifiableCredential)this.mapper.convertValue((Object)claims, VerifiableCredential.class);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private Result<Map<String, Object>> processScopeQuery(Map<String, Object> message, List<String> scopes, String audience) {
        List requestedScopes = (List)message.get("scope");
        ArrayList<String> scopeTypes = new ArrayList<String>();
        for (String requestedScope : requestedScopes) {
            Matcher matcher = SCOPE_PATTERN.matcher(requestedScope);
            if (!matcher.matches()) {
                return Result.failure((String)("Invalid scope type: " + requestedScope));
            }
            String type = matcher.group("type");
            scopeTypes.add(type);
        }
        List<VcContainer> credentials = scopeTypes.stream().flatMap(c -> Optional.ofNullable(this.credentialsByType.get(c)).stream().flatMap(Collection::stream)).filter(Objects::nonNull).toList();
        for (VcContainer container : credentials) {
            boolean found = false;
            for (String type : container.credential().getType()) {
                if (!scopes.stream().anyMatch(scope -> scope.startsWith(type))) continue;
                found = true;
                break;
            }
            if (found) continue;
            return Result.failure((String)"Access denied", (Result.ErrorType)Result.ErrorType.UNAUTHORIZED);
        }
        return this.processBaseMessage(credentials, audience);
    }

    private Result<Map<String, Object>> processPresentationQuery(Map<String, Object> message, List<String> scopes, String audience) {
        return this.processBaseMessage(List.of(), audience);
    }

    private Result<Map<String, Object>> processBaseMessage(List<VcContainer> credentials, String audience) {
        Result<String> presentation = this.generators.get((Object)PresentationGenerator.PresentationFormat.JWT).generatePresentation(audience, this.holderDid, credentials);
        Map response = DcpMessageBuilder.newInstance().type("PresentationResponseMessage").property("presentation", List.of((String)presentation.getContent())).build();
        return Result.success((Object)response);
    }
}

