/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.core.api.system.ProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.service.Result;

public class CredentialOfferHandler
implements ProtocolHandler {
    private final CredentialService credentialService;

    public CredentialOfferHandler(CredentialService credentialService) {
        this.credentialService = credentialService;
    }

    public HandlerResponse apply(Map<String, List<String>> headers, InputStream body) {
        List<String> authHeaders = headers.get("Authorization");
        if (authHeaders == null || authHeaders.isEmpty() || authHeaders.get(0).isEmpty() || !authHeaders.get(0).startsWith("Bearer ")) {
            return new HandlerResponse(401, "Missing access token");
        }
        String idToken = headers.get("Authorization").get(0);
        Result result = this.credentialService.offerCredentials(idToken = idToken.replace("Bearer", "").trim(), body);
        if (result.succeeded()) {
            return new HandlerResponse(200, "");
        }
        return switch (result.getErrorType()) {
            case Result.ErrorType.BAD_REQUEST -> new HandlerResponse(400, result.getFailure());
            case Result.ErrorType.UNAUTHORIZED -> new HandlerResponse(401, result.getFailure());
            case Result.ErrorType.NOT_FOUND -> new HandlerResponse(404, result.getFailure());
            default -> new HandlerResponse(500, result.getFailure());
        };
    }
}

