/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CredentialObject {
    @JsonProperty(value="bindingMethods")
    private final List<String> bindingMethods = new ArrayList<String>();
    @JsonProperty(value="profile")
    private String profile;
    @JsonProperty(value="issuancePolicy")
    private final Map<String, Object> issuancePolicy = new HashMap<String, Object>();
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="credentialType")
    private String credentialType;
    @JsonProperty(value="offerReason")
    private String offerReason;
    @JsonProperty(value="credentialSchema")
    private String credentialSchema;

    public List<String> getBindingMethods() {
        return this.bindingMethods;
    }

    public String getProfile() {
        return this.profile;
    }

    public Map<String, Object> getIssuancePolicy() {
        return this.issuancePolicy;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getCredentialType() {
        return this.credentialType;
    }

    public String getOfferReason() {
        return this.offerReason;
    }

    public String getCredentialSchema() {
        return this.credentialSchema;
    }

    public boolean validate() {
        if (this.type == null && this.credentialType == null && this.id != null) {
            return true;
        }
        return this.type != null && this.credentialType != null && this.id != null;
    }

    public static class Builder {
        private final CredentialObject credentialObject = new CredentialObject();

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder bindingMethods(List<String> bindingMethods) {
            this.credentialObject.bindingMethods.addAll(bindingMethods);
            return this;
        }

        public Builder profile(String profile) {
            this.credentialObject.profile = profile;
            return this;
        }

        public Builder issuancePolicy(Map<String, Object> issuancePolicy) {
            this.credentialObject.issuancePolicy.putAll(issuancePolicy);
            return this;
        }

        public Builder id(String id) {
            this.credentialObject.id = id;
            return this;
        }

        public Builder type(String type) {
            this.credentialObject.type = type;
            return this;
        }

        public Builder credentialType(String credentialType) {
            this.credentialObject.credentialType = credentialType;
            return this;
        }

        public Builder offerReason(String offerReason) {
            this.credentialObject.offerReason = offerReason;
            return this;
        }

        public Builder credentialSchema(String credentialSchema) {
            this.credentialObject.credentialSchema = credentialSchema;
            return this;
        }

        public CredentialObject build() {
            return this.credentialObject;
        }
    }
}

