/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class CredentialMessage {
    @JsonProperty(value="credentials", required=true)
    private final List<CredentialContainer> credentials = new ArrayList<CredentialContainer>();
    @JsonProperty(value="issuerPid", required=true)
    private String issuerPid;
    @JsonProperty(value="holderPid", required=true)
    private String holderPid;
    @JsonProperty(value="status", required=true, defaultValue="ISSUED")
    private String status;
    @JsonProperty(value="type", required=true)
    private String type = "CredentialMessage";

    private CredentialMessage() {
    }

    public boolean validate() {
        return List.of("ISSUED", "REJECTED").contains(this.status) && this.issuerPid != null && this.holderPid != null && !this.credentials.isEmpty();
    }

    public List<CredentialContainer> getCredentials() {
        return this.credentials;
    }

    public String getIssuerPid() {
        return this.issuerPid;
    }

    public String getHolderPid() {
        return this.holderPid;
    }

    public String getStatus() {
        return this.status;
    }

    public String getType() {
        return this.type;
    }

    public record CredentialContainer(String credentialType, String payload, String format) {
    }

    public static class Builder {
        private final CredentialMessage instance = new CredentialMessage();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder credentials(List<CredentialContainer> credentials) {
            this.instance.credentials.addAll(credentials);
            return this;
        }

        public Builder issuerPid(String issuerPid) {
            this.instance.issuerPid = issuerPid;
            return this;
        }

        public Builder holderPid(String holderPid) {
            this.instance.holderPid = holderPid;
            return this;
        }

        public Builder status(String status) {
            this.instance.status = status;
            return this;
        }

        public Builder type(String type) {
            this.instance.type = type;
            return this;
        }

        public CredentialMessage build() {
            return this.instance;
        }
    }
}

