/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.cs;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.dataspacetck.core.api.system.HandlerResponse;
import org.eclipse.dataspacetck.core.api.system.ProtocolHandler;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerService;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.jetbrains.annotations.NotNull;

public record CredentialApiHandler(CredentialService credentialService, ObjectMapper mapper, IssuerService issuerService) implements ProtocolHandler
{
    private static final TypeReference<Map<String, Object>> MAP_REF = new TypeReference<Map<String, Object>>(){};

    public HandlerResponse apply(Map<String, List<String>> headers, InputStream body) {
        List<String> authHeaders = headers.get("Authorization");
        if (authHeaders == null || authHeaders.isEmpty() || authHeaders.get(0).isEmpty() || !authHeaders.get(0).startsWith("Bearer ")) {
            return new HandlerResponse(401, "Missing access token");
        }
        String idToken = headers.get("Authorization").get(0);
        idToken = idToken.replace("Bearer", "").trim();
        try {
            String msgType;
            Map msg = (Map)this.mapper.readValue(body, MAP_REF);
            return switch (msgType = msg.getOrDefault("type", "").toString()) {
                case "CredentialMessage" -> this.toResponse(this.credentialService.writeCredentials(idToken, msg));
                case "CredentialRequestMessage" -> this.toResponse(this.issuerService.processCredentialRequest(idToken, msg));
                default -> new HandlerResponse(400, "Invalid message type, expected either '%s' or '%s', got '%s'".formatted("CredentialMessage", "CredentialRequestMessage", msgType));
            };
        }
        catch (IOException e) {
            return new HandlerResponse(400, "Invalid JSON");
        }
    }

    @NotNull
    private HandlerResponse toResponse(Result<?> result) {
        Object content = result.getContent();
        Map<Object, Object> headers = Collections.emptyMap();
        if (content != null) {
            headers = Map.of("Location", content.toString());
        }
        return switch (result.getErrorType()) {
            default -> throw new IncompatibleClassChangeError();
            case Result.ErrorType.BAD_REQUEST -> new HandlerResponse(400, result.getFailure());
            case Result.ErrorType.UNAUTHORIZED -> new HandlerResponse(401, result.getFailure());
            case Result.ErrorType.NOT_FOUND -> new HandlerResponse(404, result.getFailure());
            case Result.ErrorType.GENERAL_ERROR -> new HandlerResponse(500, result.getFailure());
            case Result.ErrorType.NO_ERROR -> new HandlerResponse(201, "", headers);
        };
    }
}

