/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.ECDSASigner;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Map;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;

public class KeyServiceImpl
implements KeyService {
    private final ECKey key;

    public KeyServiceImpl(ECKey key) {
        this.key = key;
    }

    public JWK getPublicKey() {
        return this.key.toPublicJWK();
    }

    public String sign(Map<String, String> headers, JWTClaimsSet claims) {
        JWSHeader.Builder header = new JWSHeader.Builder(JWSAlgorithm.ES256).type(JOSEObjectType.JWT);
        if (!headers.containsKey("kid")) {
            header.keyID(String.valueOf(claims.getClaim("iss")) + "#" + this.key.getKeyID());
        }
        headers.forEach((k, v) -> {
            if ("kid".equals(k)) {
                header.keyID(v);
            } else {
                header.customParam(k, v);
            }
        });
        try {
            SignedJWT signedJwt = new SignedJWT(header.build(), claims);
            signedJwt.sign((JWSSigner)new ECDSASigner(this.key.toECPrivateKey()));
            return signedJwt.serialize();
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
    }
}

