/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.assembly;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.eclipse.dataspacetck.core.api.system.CallbackEndpoint;
import org.eclipse.dataspacetck.core.api.system.ProtocolHandler;
import org.eclipse.dataspacetck.core.spi.boot.Monitor;
import org.eclipse.dataspacetck.core.spi.system.ServiceConfiguration;
import org.eclipse.dataspacetck.core.spi.system.ServiceResolver;
import org.eclipse.dataspacetck.dcp.system.assembly.BaseAssembly;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialApiHandler;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialObject;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialOfferHandler;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialServiceImpl;
import org.eclipse.dataspacetck.dcp.system.cs.PresentationHandler;
import org.eclipse.dataspacetck.dcp.system.cs.SecureTokenServerImpl;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.did.DidClient;
import org.eclipse.dataspacetck.dcp.system.did.DidDocumentHandler;
import org.eclipse.dataspacetck.dcp.system.generation.JwtCredentialGenerator;
import org.eclipse.dataspacetck.dcp.system.generation.JwtPresentationGenerator;
import org.eclipse.dataspacetck.dcp.system.handler.SchemaProvider;
import org.eclipse.dataspacetck.dcp.system.issuer.CredentialRequestHandler;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerMetadataHandler;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerService;
import org.eclipse.dataspacetck.dcp.system.issuer.IssuerServiceImpl;
import org.eclipse.dataspacetck.dcp.system.message.DcpMessageBuilder;
import org.eclipse.dataspacetck.dcp.system.model.did.DidDocument;
import org.eclipse.dataspacetck.dcp.system.model.did.ServiceEntry;
import org.eclipse.dataspacetck.dcp.system.model.vc.CredentialFormat;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.eclipse.dataspacetck.dcp.system.model.vc.VerifiableCredential;
import org.eclipse.dataspacetck.dcp.system.revocation.BitstringStatusListService;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationHandler;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationService;
import org.eclipse.dataspacetck.dcp.system.revocation.StatusList2021Service;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.eclipse.dataspacetck.dcp.system.sts.SecureTokenServer;
import org.eclipse.dataspacetck.dcp.system.sts.StsClient;
import org.eclipse.dataspacetck.dcp.system.verifier.BaseTokenValidationService;
import org.eclipse.dataspacetck.dcp.system.verifier.VerifierTriggerHandler;
import org.jetbrains.annotations.NotNull;

public class ServiceAssembly {
    private final CredentialService credentialService;
    private final SecureTokenServer secureTokenServer;
    private final IssuerService issuerService;
    private final CredentialRevocationService revocationService;

    public ServiceAssembly(BaseAssembly baseAssembly, ServiceResolver resolver, ServiceConfiguration configuration) {
        TokenValidationService tokenService = baseAssembly.getHolderTokenService();
        JwtPresentationGenerator generator = new JwtPresentationGenerator(baseAssembly.getHolderDid(), baseAssembly.getHolderKeyService());
        ObjectMapper mapper = baseAssembly.getMapper();
        Map<String, CredentialObject> supportedCredentials = this.buildSupportedCredentials();
        this.secureTokenServer = new SecureTokenServerImpl(configuration);
        this.credentialService = new CredentialServiceImpl(baseAssembly.getHolderDid(), List.of(generator), this.secureTokenServer, baseAssembly.getHolderTokenService(), mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES));
        this.issuerService = new IssuerServiceImpl(baseAssembly.getIssuerKeyService(), baseAssembly.getIssuerTokenService(), supportedCredentials);
        this.revocationService = this.createRevocationService(baseAssembly);
        CallbackEndpoint endpoint = (CallbackEndpoint)Objects.requireNonNull(resolver.resolve(CallbackEndpoint.class, configuration));
        Monitor monitor = configuration.getMonitor();
        PresentationHandler presentationHandler = new PresentationHandler(this.credentialService, tokenService, mapper, monitor);
        endpoint.registerProtocolHandler("/presentations/query", (ProtocolHandler)presentationHandler);
        endpoint.registerProtocolHandler("/credentials", (ProtocolHandler)new CredentialApiHandler(this.credentialService, mapper, this.issuerService));
        endpoint.registerProtocolHandler("/offers", (ProtocolHandler)new CredentialOfferHandler(this.credentialService));
        endpoint.registerProtocolHandler("/requests/.*", (ProtocolHandler)new CredentialRequestHandler(this.issuerService, mapper));
        endpoint.registerProtocolHandler("/metadata", (ProtocolHandler)new IssuerMetadataHandler(supportedCredentials, mapper, baseAssembly.getIssuerDid()));
        endpoint.registerHandler("/holder/did.json", (Function)new DidDocumentHandler(baseAssembly.getHolderDidService(), mapper));
        endpoint.registerHandler("/verifier/did.json", (Function)new DidDocumentHandler(baseAssembly.getVerifierDidService(), mapper));
        endpoint.registerHandler("/issuer/did.json", (Function)new DidDocumentHandler(baseAssembly.getIssuerDidService(), mapper));
        endpoint.registerHandler("/thirdparty/did.json", (Function)new DidDocumentHandler(baseAssembly.getThirdPartyDidService(), mapper));
        endpoint.registerProtocolHandler("/api/trigger", (ProtocolHandler)new VerifierTriggerHandler(baseAssembly.getVerifierTokenService(), mapper, baseAssembly.getVerifierKeyService(), baseAssembly.getVerifierDid(), new BaseTokenValidationService(), this.revocationService));
        endpoint.registerHandler("/statuslist/.*", (Function)new CredentialRevocationHandler(this.revocationService, mapper));
        endpoint.registerProtocolHandler("/schema/.*", (ProtocolHandler)new SchemaProvider());
    }

    public CredentialService getCredentialService() {
        return this.credentialService;
    }

    public CredentialRevocationService getRevocationService() {
        return this.revocationService;
    }

    public StsClient getStsClient() {
        return this.secureTokenServer;
    }

    public void issueCredentials(BaseAssembly baseAssembly) {
        String issuerDid = baseAssembly.getIssuerDid();
        JwtCredentialGenerator credentialGenerator = new JwtCredentialGenerator(issuerDid, baseAssembly.getIssuerKeyService());
        String holderDid = baseAssembly.getHolderDid();
        VcContainer membershipContainer = this.createVcContainer(issuerDid, holderDid, credentialGenerator, "MembershipCredential");
        VcContainer sensitiveDataContainer = this.createVcContainer(issuerDid, holderDid, credentialGenerator, "SensitiveDataCredential");
        String correlation = baseAssembly.getHolderPid();
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().issuer(issuerDid).audience(holderDid).subject(issuerDid).jwtID(UUID.randomUUID().toString()).issueTime(new Date()).expirationTime(Date.from(Instant.now().plusSeconds(600L))).build();
        String token = baseAssembly.getIssuerKeyService().sign(Collections.emptyMap(), claimSet);
        try {
            this.sendCredentialMessage(baseAssembly, correlation, membershipContainer, sensitiveDataContainer, token);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public VcContainer createVcContainer(String issuerDid, String holderDid, JwtCredentialGenerator credentialGenerator, String credentialType) {
        VerifiableCredential credential = this.createCredential(issuerDid, holderDid, credentialType);
        Result<String> result = credentialGenerator.generateCredential(credential);
        return new VcContainer((String)result.getContent(), credential, CredentialFormat.VC1_0_JWT);
    }

    private Map<String, CredentialObject> buildSupportedCredentials() {
        HashMap map = new HashMap();
        Stream.of("vc11-sl2021/jwt", "vc20-bssl/jwt").forEach(profile -> {
            CredentialObject membershipCredential = CredentialObject.Builder.newInstance().id(UUID.randomUUID().toString()).type("CredentialObject").credentialType("MembershipCredential").offerReason("issuance").bindingMethods(Collections.singletonList("did:web")).profile((String)profile).build();
            map.put(membershipCredential.getId(), membershipCredential);
            CredentialObject sensitiveDataCredential = CredentialObject.Builder.newInstance().id(UUID.randomUUID().toString()).type("CredentialObject").credentialType("SensitiveDataCredential").offerReason("issuance").bindingMethods(Collections.singletonList("did:web")).profile((String)profile).build();
            map.put(sensitiveDataCredential.getId(), sensitiveDataCredential);
        });
        return Collections.unmodifiableMap(map);
    }

    private CredentialRevocationService createRevocationService(BaseAssembly baseAssembly) {
        return switch (baseAssembly.getRevocationListType().toLowerCase()) {
            case "bitstringstatuslist" -> new BitstringStatusListService(baseAssembly.getIssuerDid(), baseAssembly.getAddress());
            case "statuslist2021" -> new StatusList2021Service(baseAssembly.getIssuerDid(), baseAssembly.getAddress());
            default -> throw new IllegalArgumentException("Unsupported revocation list type: " + baseAssembly.getRevocationListType());
        };
    }

    private void sendCredentialMessage(BaseAssembly baseAssembly, String correlation, VcContainer membershipContainer, VcContainer sensitiveDataContainer, String token) throws JsonProcessingException {
        DcpMessageBuilder credentialsObject = DcpMessageBuilder.newInstance().type("CredentialMessage").property("requestId", (Object)correlation).property("issuerPid", (Object)UUID.randomUUID().toString()).property("holderPid", (Object)correlation).property("credentials", List.of(Map.of("credentialType", "MembershipCredential", "format", "VC1_0_JWT", "payload", membershipContainer.rawCredential()), Map.of("credentialType", "SensitiveDataCredential", "format", "VC1_0_JWT", "payload", sensitiveDataContainer.rawCredential()))).property("status", (Object)"ISSUED");
        String msg = baseAssembly.getMapper().writeValueAsString((Object)credentialsObject.build());
        this.sendCredentialServiceMessage(msg, "/credentials", token, baseAssembly.getHolderDid());
    }

    private void sendCredentialServiceMessage(String messageObject, String path, String token, String holderDid) {
        DidDocument dd = new DidClient(false).resolveDocument(holderDid);
        ServiceEntry service = dd.getServiceEntry("CredentialService");
        try {
            Request rq = new Request.Builder().url(service.serviceEndpoint() + path).post(RequestBody.create((String)messageObject, (MediaType)MediaType.parse((String)"application/json"))).addHeader("Authorization", "Bearer " + token).build();
            OkHttpClient client = new OkHttpClient();
            try (Response response = client.newCall(rq).execute();){
                if (!response.isSuccessful()) {
                    throw new RuntimeException("Failed to seed credentials: " + response.message());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private VerifiableCredential createCredential(String issuerDid, String holderDid, String credentialType) {
        return VerifiableCredential.Builder.newInstance().id(UUID.randomUUID().toString()).issuanceDate(Instant.now().toString()).issuer(issuerDid).type(List.of(credentialType)).credentialSubject(Map.of("id", holderDid, "foo", "bar")).build();
    }
}

