/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.assembly;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.dataspacetck.core.spi.system.SystemConfiguration;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyServiceImpl;
import org.eclipse.dataspacetck.dcp.system.crypto.Keys;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationService;
import org.eclipse.dataspacetck.dcp.system.cs.TokenValidationServiceImpl;
import org.eclipse.dataspacetck.dcp.system.did.DidService;
import org.eclipse.dataspacetck.dcp.system.did.DidServiceImpl;
import org.eclipse.dataspacetck.dcp.system.did.IssuerDidService;

public class BaseAssembly {
    private final String address;
    private final String issuerDid;
    private final KeyService issuerKeyService;
    private final DidService issuerDidService;
    private final String holderDid;
    private final KeyService holderKeyService;
    private final DidService holderDidService;
    private final String verifierDid;
    private final KeyService verifierKeyService;
    private final DidService verifierDidService;
    private final TokenValidationService verifierTokenService;
    private final TokenValidationService holderTokenService;
    private final TokenValidationService issuerTokenService;
    private final String thirdPartyDid;
    private final KeyServiceImpl thirdPartyKeyService;
    private final DidServiceImpl thirdPartyDidService;
    private final ObjectMapper mapper = new ObjectMapper();
    private final String holderPid;
    private final String verifierTriggerEndpoint;
    private final String revocationListType;

    public BaseAssembly(SystemConfiguration configuration) {
        this.address = configuration.getPropertyAsString("dataspacetck.callback.address", "http://localhost:8083");
        String verifierDid = configuration.getPropertyAsString("dataspacetck.did.verifier", null);
        this.verifierDid = Objects.requireNonNullElseGet(verifierDid, () -> this.parseDid("verifier"));
        String id = configuration.getPropertyAsString("dataspacetck.did.issuer", null);
        this.issuerDid = Objects.requireNonNullElseGet(id, () -> this.parseDid("issuer"));
        String did3p = configuration.getPropertyAsString("dataspacetck.did.thirdparty", null);
        this.thirdPartyDid = Objects.requireNonNullElseGet(did3p, () -> this.parseDid("thirdparty"));
        this.issuerKeyService = new KeyServiceImpl(Keys.generateEcKey());
        this.issuerDidService = new IssuerDidService(this.issuerDid, this.address, this.issuerKeyService);
        this.issuerTokenService = new TokenValidationServiceImpl(this.issuerDid);
        String hd = configuration.getPropertyAsString("dataspacetck.did.holder", null);
        this.holderDid = Objects.requireNonNullElseGet(hd, () -> this.parseDid("holder"));
        this.holderKeyService = new KeyServiceImpl(Keys.generateEcKey());
        this.holderDidService = new DidServiceImpl(this.holderDid, this.address, this.holderKeyService);
        this.holderTokenService = new TokenValidationServiceImpl(this.holderDid);
        this.holderPid = Optional.ofNullable(configuration.getPropertyAsString("dataspacetck.credentials.correlation.id", null)).orElseGet(() -> UUID.randomUUID().toString());
        this.verifierTokenService = new TokenValidationServiceImpl(this.verifierDid);
        this.verifierKeyService = new KeyServiceImpl(Keys.generateEcKey());
        this.verifierDidService = new DidServiceImpl(this.verifierDid, this.address, this.verifierKeyService);
        this.verifierTriggerEndpoint = (String)((Object)Objects.requireNonNullElse(configuration.getPropertyAsString("dataspacetck.vpp.trigger.endpoint", null), this.address + "/api/trigger"));
        this.thirdPartyKeyService = new KeyServiceImpl(Keys.generateEcKey());
        this.thirdPartyDidService = new DidServiceImpl(this.thirdPartyDid, this.address, this.thirdPartyKeyService);
        this.revocationListType = configuration.getPropertyAsString("dataspacetck.revocation.type", "bitstringstatuslist");
    }

    public String getVerifierTriggerEndpoint() {
        return this.verifierTriggerEndpoint;
    }

    public TokenValidationService getIssuerTokenService() {
        return this.issuerTokenService;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String getAddress() {
        return this.address;
    }

    public String getVerifierDid() {
        return this.verifierDid;
    }

    public TokenValidationService getVerifierTokenService() {
        return this.verifierTokenService;
    }

    public KeyService getVerifierKeyService() {
        return this.verifierKeyService;
    }

    public DidService getVerifierDidService() {
        return this.verifierDidService;
    }

    public String getHolderDid() {
        return this.holderDid;
    }

    public KeyService getHolderKeyService() {
        return this.holderKeyService;
    }

    public DidService getHolderDidService() {
        return this.holderDidService;
    }

    public TokenValidationService getHolderTokenService() {
        return this.holderTokenService;
    }

    public String getIssuerDid() {
        return this.issuerDid;
    }

    public KeyService getIssuerKeyService() {
        return this.issuerKeyService;
    }

    public DidService getIssuerDidService() {
        return this.issuerDidService;
    }

    public String getThirdPartyDid() {
        return this.thirdPartyDid;
    }

    public KeyServiceImpl getThirdPartyKeyService() {
        return this.thirdPartyKeyService;
    }

    public DidServiceImpl getThirdPartyDidService() {
        return this.thirdPartyDidService;
    }

    public String getHolderPid() {
        return this.holderPid;
    }

    public String getRevocationListType() {
        return this.revocationListType;
    }

    private String parseDid(String discriminator) {
        URI uri = URI.create(this.address);
        return uri.getPort() != 443 ? String.format("did:web:%s%%3A%s:%s", uri.getHost(), uri.getPort(), discriminator) : String.format("did:web:%s:%s", uri.getHost(), discriminator);
    }
}

