/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.dataspacetck.core.spi.system.ServiceConfiguration;
import org.eclipse.dataspacetck.core.spi.system.ServiceResolver;
import org.eclipse.dataspacetck.core.spi.system.SystemConfiguration;
import org.eclipse.dataspacetck.core.spi.system.SystemLauncher;
import org.eclipse.dataspacetck.dcp.system.annotation.AuthToken;
import org.eclipse.dataspacetck.dcp.system.annotation.Credential;
import org.eclipse.dataspacetck.dcp.system.annotation.Did;
import org.eclipse.dataspacetck.dcp.system.annotation.Holder;
import org.eclipse.dataspacetck.dcp.system.annotation.HolderPid;
import org.eclipse.dataspacetck.dcp.system.annotation.IssueCredentials;
import org.eclipse.dataspacetck.dcp.system.annotation.Issuer;
import org.eclipse.dataspacetck.dcp.system.annotation.ThirdParty;
import org.eclipse.dataspacetck.dcp.system.annotation.TriggerEndpoint;
import org.eclipse.dataspacetck.dcp.system.annotation.Verifier;
import org.eclipse.dataspacetck.dcp.system.assembly.BaseAssembly;
import org.eclipse.dataspacetck.dcp.system.assembly.ServiceAssembly;
import org.eclipse.dataspacetck.dcp.system.crypto.KeyService;
import org.eclipse.dataspacetck.dcp.system.cs.CredentialService;
import org.eclipse.dataspacetck.dcp.system.did.DidService;
import org.eclipse.dataspacetck.dcp.system.generation.JwtCredentialGenerator;
import org.eclipse.dataspacetck.dcp.system.model.vc.VcContainer;
import org.eclipse.dataspacetck.dcp.system.revocation.CredentialRevocationService;
import org.eclipse.dataspacetck.dcp.system.service.Result;
import org.jetbrains.annotations.Nullable;

public class DcpSystemLauncher
implements SystemLauncher {
    private final Map<String, ServiceAssembly> serviceAssemblies = new ConcurrentHashMap<String, ServiceAssembly>();
    private BaseAssembly baseAssembly;

    public void start(SystemConfiguration configuration) {
        this.baseAssembly = new BaseAssembly(configuration);
    }

    public <T> boolean providesService(Class<T> type) {
        return type.isAssignableFrom(CredentialService.class) || type.isAssignableFrom(CredentialRevocationService.class) || type.isAssignableFrom(DidService.class) || type.isAssignableFrom(String.class) || type.isAssignableFrom(KeyService.class) || type.isAssignableFrom(VcContainer.class);
    }

    @Nullable
    public <T> T getService(Class<T> type, ServiceConfiguration configuration, ServiceResolver resolver) {
        String scopeId = configuration.getScopeId();
        ServiceAssembly assembly = this.serviceAssemblies.computeIfAbsent(scopeId, id -> new ServiceAssembly(this.baseAssembly, resolver, configuration));
        if (type.isAssignableFrom(CredentialService.class)) {
            return type.cast(assembly.getCredentialService());
        }
        if (type.isAssignableFrom(CredentialRevocationService.class)) {
            return type.cast(assembly.getRevocationService());
        }
        if (type.isAssignableFrom(VcContainer.class)) {
            if (this.hasAnnotation(Credential.class, configuration)) {
                JwtCredentialGenerator gen = new JwtCredentialGenerator(this.baseAssembly.getIssuerDid(), this.baseAssembly.getIssuerKeyService());
                Optional<Credential> credentialType = this.getAnnotation(Credential.class, configuration);
                if (credentialType.isPresent()) {
                    return type.cast(assembly.createVcContainer(this.baseAssembly.getIssuerDid(), this.baseAssembly.getHolderDid(), gen, credentialType.get().value()));
                }
            }
        } else if (type.isAssignableFrom(KeyService.class)) {
            if (this.hasAnnotation(Verifier.class, configuration)) {
                return type.cast(this.baseAssembly.getVerifierKeyService());
            }
            if (this.hasAnnotation(Holder.class, configuration)) {
                return type.cast(this.baseAssembly.getHolderKeyService());
            }
            if (this.hasAnnotation(ThirdParty.class, configuration)) {
                return type.cast(this.baseAssembly.getThirdPartyKeyService());
            }
            if (this.hasAnnotation(Issuer.class, configuration)) {
                return type.cast(this.baseAssembly.getIssuerKeyService());
            }
        } else if (type.isAssignableFrom(DidService.class)) {
            if (this.hasAnnotation(Verifier.class, configuration)) {
                return type.cast(this.baseAssembly.getVerifierDidService());
            }
            if (this.hasAnnotation(Holder.class, configuration)) {
                return type.cast(this.baseAssembly.getHolderDidService());
            }
            if (this.hasAnnotation(ThirdParty.class, configuration)) {
                return type.cast(this.baseAssembly.getThirdPartyDidService());
            }
            if (this.hasAnnotation(Issuer.class, configuration)) {
                return type.cast(this.baseAssembly.getIssuerDidService());
            }
        } else if (type.isAssignableFrom(String.class)) {
            if (this.hasAnnotation(AuthToken.class, configuration)) {
                return this.createAuthToken(type, configuration, assembly);
            }
            if (this.hasAnnotation(HolderPid.class, configuration)) {
                return type.cast(this.baseAssembly.getHolderPid());
            }
            if (this.hasAnnotation(TriggerEndpoint.class, configuration)) {
                return type.cast(this.baseAssembly.getVerifierTriggerEndpoint());
            }
            Optional<Did> did = this.getAnnotation(Did.class, configuration);
            if (did.isPresent()) {
                switch (did.get().value()) {
                    case HOLDER: {
                        return type.cast(this.baseAssembly.getHolderDid());
                    }
                    case VERIFIER: {
                        return type.cast(this.baseAssembly.getVerifierDid());
                    }
                    case THIRD_PARTY: {
                        return type.cast(this.baseAssembly.getThirdPartyDid());
                    }
                    case ISSUER: {
                        return type.cast(this.baseAssembly.getIssuerDid());
                    }
                }
                throw new UnsupportedOperationException("Unsupported DID role: " + String.valueOf(did.get().value()));
            }
        }
        return (T)super.getService(type, configuration, resolver);
    }

    public void beforeExecution(ServiceConfiguration configuration, ServiceResolver resolver) {
        if (this.hasAnnotation(IssueCredentials.class, configuration)) {
            this.serviceAssemblies.get(configuration.getScopeId()).issueCredentials(this.baseAssembly);
        }
    }

    private <T> T createAuthToken(Class<T> type, ServiceConfiguration configuration, ServiceAssembly assembly) {
        List<String> scopes = Arrays.asList(this.getAnnotation(AuthToken.class, configuration).orElseThrow().value());
        Result<String> tokenResult = assembly.getStsClient().obtainReadToken(this.baseAssembly.getVerifierDid(), scopes);
        if (tokenResult.failed()) {
            throw new AssertionError((Object)tokenResult.getFailure());
        }
        return type.cast(tokenResult.getContent());
    }

    private boolean hasAnnotation(Class<? extends Annotation> annotation, ServiceConfiguration configuration) {
        return configuration.getAnnotations().stream().anyMatch(a -> a.annotationType().equals(annotation));
    }

    private <A extends Annotation> Optional<A> getAnnotation(Class<A> annotation, ServiceConfiguration configuration) {
        return configuration.getAnnotations().stream().filter(a -> a.annotationType().equals(annotation)).findFirst();
    }
}

