/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.service;

import java.util.Optional;

public class Result<T> {
    private final T content;
    private final String failure;
    private final ErrorType errorType;

    private Result(T content, String failure, ErrorType errorType) {
        this.content = content;
        this.failure = failure;
        this.errorType = errorType;
    }

    public static Result<Void> success() {
        return new Result<Object>(null, null, ErrorType.NO_ERROR);
    }

    public static <T> Result<T> success(T content) {
        return new Result<T>(content, null, ErrorType.NO_ERROR);
    }

    public static <T> Result<T> failure(String failure) {
        return new Result<Object>(null, failure, ErrorType.GENERAL_ERROR);
    }

    public static <T> Result<T> failure(String failure, ErrorType errorType) {
        return new Result<Object>(null, failure, errorType);
    }

    public boolean succeeded() {
        return this.failure == null;
    }

    public boolean failed() {
        return !this.succeeded();
    }

    public T getContent() {
        return this.content;
    }

    public String getFailure() {
        return this.failure;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public <R> R convert() {
        return (R)this;
    }

    public String toString() {
        return this.succeeded() ? Optional.ofNullable(this.getContent()).orElseGet(() -> "").toString() : this.failure;
    }

    public static enum ErrorType {
        NOT_FOUND,
        UNAUTHORIZED,
        BAD_REQUEST,
        GENERAL_ERROR,
        NO_ERROR;

    }
}

