/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dataspacetck.dcp.system.model.vc;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.dataspacetck.dcp.system.model.ExtensibleModel;
import org.eclipse.dataspacetck.dcp.system.model.vc.MetadataReference;

@JsonDeserialize(builder=Builder.class)
public class VerifiableCredential
extends ExtensibleModel {
    private final List<String> type = new ArrayList<String>();
    private Map<String, Object> credentialSubject = new LinkedHashMap<String, Object>();
    private String id;
    private String issuer;
    private String issuanceDate;
    private String expirationDate;
    private MetadataReference credentialSchema;
    private MetadataReference credentialStatus;

    public String getId() {
        return this.id;
    }

    @JsonProperty
    public List<String> getType() {
        return this.type;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssuanceDate() {
        return this.issuanceDate;
    }

    public Map<String, Object> getCredentialSubject() {
        return this.credentialSubject;
    }

    public MetadataReference getCredentialSchema() {
        return this.credentialSchema;
    }

    public MetadataReference getCredentialStatus() {
        return this.credentialStatus;
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("@context", this.id);
        map.put("id", this.id);
        map.put("type", this.type);
        map.put("issuer", this.issuer);
        map.put("issuanceDate", this.issuanceDate);
        map.put("expirationDate", this.expirationDate);
        if (this.credentialSchema != null) {
            map.put("credentialSchema", this.credentialSchema);
        }
        if (this.credentialSchema != null) {
            map.put("credentialSchema", this.credentialSchema.toMap());
        }
        if (this.credentialStatus != null) {
            map.put("credentialStatus", this.credentialStatus.toMap());
        }
        map.put("credentialSubject", this.credentialSubject);
        return map;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends ExtensibleModel.Builder<Builder> {
        private final VerifiableCredential credential = new VerifiableCredential();

        private Builder() {
            this.setModel(this.credential);
        }

        @JsonCreator
        public static Builder newInstance() {
            return new Builder();
        }

        public Builder id(String id) {
            this.credential.id = id;
            return this;
        }

        public Builder type(List<String> type) {
            this.credential.type.addAll(type);
            return this;
        }

        public Builder issuer(String issuer) {
            this.credential.issuer = issuer;
            return this;
        }

        public Builder issuanceDate(String date) {
            this.credential.issuanceDate = date;
            return this;
        }

        public Builder expirationDate(String date) {
            this.credential.expirationDate = date;
            return this;
        }

        public Builder credentialSchema(MetadataReference credentialSchema) {
            this.credential.credentialSchema = credentialSchema;
            return this;
        }

        public Builder credentialStatus(MetadataReference status) {
            this.credential.credentialStatus = status;
            return this;
        }

        public Builder credentialSubject(Map<String, Object> subject) {
            this.credential.credentialSubject = subject;
            return this;
        }

        public VerifiableCredential build() {
            Objects.requireNonNull(this.credential.id, "id");
            if (this.credential.context.contains("https://www.w3.org/2018/credentials/v1") && !this.credential.context.contains("https://www.w3.org/ns/credentials/v2")) {
                this.credential.context.add(0, "https://www.w3.org/2018/credentials/v1");
            }
            return this.credential;
        }
    }
}

